/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.network.packet.AnimDataSyncPacket;
import software.bernie.geckolib.network.packet.AnimTriggerPacket;
import software.bernie.geckolib.network.packet.StopTriggeredSingletonAnimPacket;

public interface SingletonGeoAnimatable
extends GeoAnimatable {
    public static void registerSyncedAnimatable(GeoAnimatable animatable) {
        GeckoLibNetwork.registerSyncedAnimatable(animatable);
    }

    @Nullable
    default public <D> D getAnimData(long instanceId, SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(instanceId).getData(dataTicket);
    }

    default public <D> void setAnimData(Entity relatedEntity, long instanceId, SerializableDataTicket<D> dataTicket, D data) {
        if (relatedEntity.m_9236_().m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(instanceId).setData(dataTicket, data);
        } else {
            this.syncAnimData(instanceId, dataTicket, data, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> relatedEntity));
        }
    }

    default public <D> void syncAnimData(long instanceId, SerializableDataTicket<D> dataTicket, D data, PacketDistributor.PacketTarget packetTarget) {
        GeckoLibNetwork.send(new AnimDataSyncPacket<D>(GeckoLibNetwork.getSyncedSingletonAnimatableId(this), instanceId, dataTicket, data), packetTarget);
    }

    default public <D> void triggerAnim(Entity relatedEntity, long instanceId, @Nullable String controllerName, String animName) {
        if (relatedEntity.m_9236_().m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(instanceId).tryTriggerAnimation(controllerName, animName);
        } else {
            this.triggerAnim(instanceId, controllerName, animName, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> relatedEntity));
        }
    }

    default public <D> void triggerAnim(long instanceId, @Nullable String controllerName, String animName, PacketDistributor.PacketTarget packetTarget) {
        GeckoLibNetwork.send(new AnimTriggerPacket(GeckoLibNetwork.getSyncedSingletonAnimatableId(this), instanceId, controllerName, animName), packetTarget);
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnim(Entity relatedEntity, long instanceId, @Nullable String controllerName, @Nullable String animName) {
        if (relatedEntity.m_9236_().m_5776_()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(instanceId);
            if (animatableManager == null) {
                return;
            }
            if (controllerName != null) {
                animatableManager.stopTriggeredAnimation(controllerName, animName);
            } else {
                animatableManager.stopTriggeredAnimation(animName);
            }
        } else {
            this.stopTriggeredAnim(relatedEntity, instanceId, controllerName, animName, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> relatedEntity));
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnim(Entity relatedEntity, long instanceId, @Nullable String controllerName, @Nullable String animName, PacketDistributor.PacketTarget packetTarget) {
        GeckoLibNetwork.send(new StopTriggeredSingletonAnimPacket(GeckoLibNetwork.getSyncedSingletonAnimatableId(this), instanceId, controllerName, animName), packetTarget);
    }

    @ApiStatus.NonExtendable
    default public void triggerArmorAnim(Entity relatedEntity, long instanceId, @Nullable String controllerName, String animName) {
        this.triggerAnim(relatedEntity, -instanceId, controllerName, animName);
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredArmorAnim(Entity relatedEntity, long instanceId, @Nullable String controllerName, @Nullable String animName) {
        this.stopTriggeredAnim(relatedEntity, -instanceId, controllerName, animName);
    }

    @Override
    @Nullable
    default public AnimatableInstanceCache animatableCacheOverride() {
        return new SingletonAnimatableInstanceCache(this);
    }
}

