/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.SleepTightPlatformStuff;
import net.mehvahdjukaar.sleep_tight.client.ClientEvents;
import net.mehvahdjukaar.sleep_tight.common.InvigoratedEffect;
import net.mehvahdjukaar.sleep_tight.common.blocks.IModBed;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.blocks.InfestedBedBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.NightBagBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.items.BedbugEggsItem;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundNightmarePacket;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundSyncPlayerSleepCapMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.common.tiles.IExtraBedDataProvider;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.mehvahdjukaar.sleep_tight.core.SleepEffectsHelper;
import net.mehvahdjukaar.sleep_tight.core.WakeReason;
import net.mehvahdjukaar.sleep_tight.core.WakeUpEncounterHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ModEvents {
    public static long getWakeUpTimeWhenSlept(ServerLevel level, long newTimeDayTime) {
        WakeReason wakeReason = WakeReason.SLEPT_SUCCESSFULLY;
        List<ServerPlayer> sleepingPlayers = level.m_6907_().stream().filter(Player::m_36317_).toList();
        ISleepTightBed firstValid = (ISleepTightBed)Blocks.f_50028_;
        for (Player player : sleepingPlayers) {
            ISleepTightBed st;
            Block block = level.m_8055_((BlockPos)player.m_21257_().get()).m_60734_();
            if (!(block instanceof ISleepTightBed)) continue;
            firstValid = st = (ISleepTightBed)block;
            break;
        }
        HashSet<ServerPlayer> encounterSpawnedFor = new HashSet<ServerPlayer>();
        for (ServerPlayer player : sleepingPlayers) {
            if (!player.f_8941_.m_9294_() || !WakeUpEncounterHelper.tryPerformEncounter(player, level, (BlockPos)player.m_21257_().get())) continue;
            wakeReason = WakeReason.ENCOUNTER;
            encounterSpawnedFor.add(player);
        }
        if (wakeReason == WakeReason.SLEPT_SUCCESSFULLY) {
            double nightmareChance;
            double d = 0.0;
            int players = 0;
            for (ServerPlayer player : sleepingPlayers) {
                ++players;
                PlayerSleepData c = SleepTightPlatformStuff.getPlayerSleepData((Player)player);
                d += c.getNightmareChance((Player)player, (BlockPos)player.m_21257_().get());
            }
            double d2 = nightmareChance = players == 0 ? 0.0 : d / (double)players;
            if ((double)level.f_46441_.m_188501_() < nightmareChance) {
                wakeReason = WakeReason.NIGHTMARE;
            }
        }
        long l = level.m_46468_();
        long newWakeTime = firstValid.st_modifyWakeUpTime(wakeReason, newTimeDayTime, l);
        long dayTimeDelta = (newWakeTime + 24000L - l) % 24000L;
        for (ServerPlayer player : sleepingPlayers) {
            switch (wakeReason) {
                case SLEPT_SUCCESSFULLY: {
                    ModEvents.onPlayerSleepFinished(player, dayTimeDelta);
                    break;
                }
                case ENCOUNTER: {
                    ModEvents.onEncounter(player, encounterSpawnedFor.contains(player));
                    break;
                }
                case NIGHTMARE: {
                    ModEvents.onNightmare(player);
                }
            }
        }
        return newWakeTime;
    }

    public static boolean canSetSpawn(Player player, @Nullable BlockPos pos) {
        if (pos != null) {
            Level level = player.m_9236_();
            Block block = level.m_8055_(pos).m_60734_();
            if (block instanceof BedBlock) {
                if (CommonConfigs.ONLY_RESPAWN_IN_HOME_BED.get().booleanValue() && PlayerSleepData.getHomeBedIfHere(player, pos) == null) {
                    return false;
                }
                if (!BedBlock.m_49488_((Level)level) && !CommonConfigs.EXPLOSION_BEHAVIOR.get().canRespawn()) {
                    return false;
                }
            }
            if (block instanceof NightBagBlock) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidBed(BlockState state) {
        Block block = state.m_60734_();
        return block instanceof BedBlock && block != SleepTight.INFESTED_BED;
    }

    public static InteractionResult onRightClickBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.m_5833_()) {
            BlockPos pos = hitResult.m_82425_();
            BlockState state = level.m_8055_(pos);
            Block b = state.m_60734_();
            if (b instanceof InfestedBedBlock) {
                return state.m_60664_(level, player, hand, hitResult);
            }
            if (ModEvents.isValidBed(state)) {
                Direction dir = (Direction)state.m_61143_((Property)BedBlock.f_54117_);
                if (state.m_61143_((Property)BedBlock.f_49440_) != BedPart.HEAD && !(state = level.m_8055_(pos = pos.m_121945_(dir))).m_60713_(b)) {
                    return InteractionResult.PASS;
                }
                ItemStack itemInHand = player.m_21120_(hand);
                Item item = itemInHand.m_41720_();
                if (item instanceof BedbugEggsItem) {
                    BedbugEggsItem bb = (BedbugEggsItem)item;
                    return bb.useOnBed(player, hand, itemInHand, state, pos, hitResult);
                }
                if (BedBlock.m_49488_((Level)level) && !player.m_36341_() && !ModEvents.bedBlocked(level, pos, dir) && !player.m_6047_()) {
                    boolean occupied = (Boolean)state.m_61143_((Property)BedBlock.f_49441_);
                    if (occupied) {
                        List list = level.m_45976_(BedEntity.class, new AABB(pos));
                        if (list.size() > 0) {
                            BedEntity bedEntity = (BedEntity)((Object)list.get(0));
                            if (!bedEntity.isDoubleBed()) {
                                return InteractionResult.PASS;
                            }
                            bedEntity.clearDoubleBed();
                            pos = bedEntity.getDoubleBedPos();
                            state = (BlockState)state.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(false));
                            level.m_46597_(pos, state);
                            occupied = false;
                        } else {
                            BlockPos doublePos = BedEntity.getInverseDoubleBedPos(pos, state);
                            list = level.m_45976_(BedEntity.class, new AABB(doublePos));
                            if (list.size() > 0) {
                                BedEntity bedEntity = (BedEntity)((Object)list.get(0));
                                if (!bedEntity.isDoubleBed()) {
                                    return InteractionResult.PASS;
                                }
                                bedEntity.clearDoubleBed();
                                state = (BlockState)state.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(false));
                                level.m_46597_(pos, state);
                                occupied = false;
                            }
                        }
                    }
                    if (!occupied) {
                        boolean extraConditions;
                        boolean bl = extraConditions = CommonConfigs.LAY_WHEN_ON_COOLDOWN.get() != false || ModEvents.checkExtraSleepConditions(player, pos);
                        if (!extraConditions) {
                            return InteractionResult.m_19078_((boolean)level.f_46443_);
                        }
                        BedEntity.layDown(state, level, pos, player);
                        return InteractionResult.SUCCESS;
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    private static boolean bedBlocked(Level level, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.m_7494_();
        return !ModEvents.freeAt(level, blockPos) || !ModEvents.freeAt(level, blockPos.m_121945_(direction.m_122424_()));
    }

    protected static boolean freeAt(Level level, BlockPos pos) {
        return !level.m_8055_(pos).m_60828_((BlockGetter)level, pos);
    }

    public static Vec3 getSleepingPosition(Entity entity, BlockState state, BlockPos pos) {
        Block block;
        if (entity.m_9236_().f_46443_) {
            ClientEvents.onSleepStarted(entity, state, pos);
        }
        if ((block = state.m_60734_()) instanceof IModBed) {
            IModBed iModBed = (IModBed)block;
            return iModBed.getSleepingPosition(state, pos);
        }
        if (state.m_204336_(BlockTags.f_13038_)) {
            Player player;
            PlayerSleepData data;
            Vec3 c = Vec3.f_82478_;
            if (CommonConfigs.FIX_BED_POSITION.get().booleanValue()) {
                c = c.m_82520_((double)pos.m_123341_() + 0.5, (double)((float)pos.m_123342_() + 0.5625f), (double)pos.m_123343_() + 0.5);
            }
            if (entity instanceof Player && (data = SleepTightPlatformStuff.getPlayerSleepData(player = (Player)entity)).usingDoubleBed()) {
                c = BedEntity.getDoubleBedOffset((Direction)state.m_61143_((Property)BedBlock.f_54117_), c);
            }
            if (c != Vec3.f_82478_) {
                return c;
            }
        }
        return null;
    }

    private static void onEncounter(ServerPlayer player, boolean mobSpawned) {
        if (mobSpawned) {
            PlayerSleepData c = SleepTightPlatformStuff.getPlayerSleepData((Player)player);
            c.addInsomnia((Player)player, CommonConfigs.ENCOUNTER_INSOMNIA_DURATION.get().intValue());
            c.setLasWokenUpTime(player.m_9236_());
            c.resetConsecutiveNightSleptCounter();
            c.syncToClient(player);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"message.sleep_tight.encounter"), true);
        }
    }

    private static void onNightmare(ServerPlayer player) {
        PlayerSleepData c = SleepTightPlatformStuff.getPlayerSleepData((Player)player);
        c.addInsomnia((Player)player, CommonConfigs.NIGHTMARE_INSOMNIA_DURATION.get().intValue());
        c.setLasWokenUpTime(player.m_9236_());
        c.resetConsecutiveNightSleptCounter();
        c.syncToClient(player);
        player.m_5661_((Component)Component.m_237115_((String)"message.sleep_tight.nightmare"), true);
        player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 60, 0, false, false, false, null, Optional.of(new MobEffectInstance.FactorData(20, 10.0f, 1.0f, 1.0f, 60, 1.0f, true))));
        NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundNightmarePacket());
    }

    public static void onPlayerSleepFinished(ServerPlayer player, long dayTimeDelta) {
        Optional p = player.m_21257_();
        if (p.isPresent()) {
            BlockPos pos = (BlockPos)p.get();
            PlayerSleepData playerCap = SleepTightPlatformStuff.getPlayerSleepData((Player)player);
            Level level = player.m_9236_();
            BlockState state = level.m_8055_(pos);
            ISleepTightBed bed = (ISleepTightBed)Blocks.f_50028_;
            Block block = state.m_60734_();
            if (block instanceof ISleepTightBed) {
                ISleepTightBed b;
                bed = b = (ISleepTightBed)block;
            }
            BedData data = null;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof IExtraBedDataProvider) {
                IExtraBedDataProvider tile = (IExtraBedDataProvider)blockEntity;
                data = tile.st_getBedData();
                playerCap.maybeIncreaseNightsInHomeBed(data, (Player)player);
            }
            playerCap.increaseConsecutiveNightSleptCounter((Player)player);
            playerCap.setLasWokenUpTime(player.m_9236_());
            if (bed.st_canSpawnBedbugs()) {
                WakeUpEncounterHelper.trySpawningBedbug(pos, player, data);
            }
            SleepEffectsHelper.applyEffectsOnWakeUp(playerCap, player, dayTimeDelta, pos, bed, state, data);
            playerCap.addInsomnia((Player)player, bed.st_getCooldown());
            playerCap.syncToClient(player);
        }
    }

    public static void onWokenUp(Player player, boolean hasWokenUpImmediately) {
        Optional p = player.m_21257_();
        if (p.isPresent()) {
            BlockPos pos = (BlockPos)p.get();
            Level level = player.m_9236_();
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof IModBed) {
                IModBed bed = (IModBed)block;
                bed.onLeftBed(state, pos, player);
            } else if (state.m_204336_(BlockTags.f_13038_) && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PlayerSleepData data = SleepTightPlatformStuff.getPlayerSleepData(player);
                if (data.usingDoubleBed()) {
                    BlockPos doublePos = BedEntity.getDoubleBedPos(pos, state);
                    BlockState doubleState = level.m_8055_(doublePos);
                    if (doubleState.m_204336_(BlockTags.f_13038_) && (doubleState = (BlockState)doubleState.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(false))) == state) {
                        level.m_46597_(doublePos, doubleState);
                    }
                    data.setDoubleBed(false);
                    data.syncToClient(serverPlayer);
                }
            }
        }
    }

    public static boolean shouldCancelSetSpawn(Player entity, BlockPos newSpawn) {
        Block block = entity.m_9236_().m_8055_(newSpawn).m_60734_();
        if (block instanceof IModBed) {
            IModBed bed = (IModBed)block;
            return !bed.canSetSpawn();
        }
        return false;
    }

    public static void onPlayerLoggedIn(ServerPlayer player) {
        NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSyncPlayerSleepCapMessage((Player)player));
    }

    public static boolean checkExtraSleepConditions(Player player, @Nullable BlockPos bedPos) {
        if (SleepTightPlatformStuff.getPlayerSleepData(player).isOnSleepCooldown(player)) {
            if (!player.m_9236_().f_46443_) {
                String s = ModEvents.isDayTime(player.m_9236_()) ? "message.sleep_tight.insomnia.day" : "message.sleep_tight.insomnia.night";
                player.m_5661_((Component)Component.m_237115_((String)s), true);
            }
            return false;
        }
        return SleepEffectsHelper.checkExtraRequirements(player, bedPos);
    }

    public static InteractionResult onCheckSleepTime(Level level, BlockPos pos) {
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof IModBed) {
            IModBed bed = (IModBed)block;
            return bed.canSleepAtTime(level);
        }
        return InteractionResult.PASS;
    }

    public static void onEntityKilled(LivingEntity entity, Entity killer) {
        Level level;
        if (!entity.m_213877_() && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (killer instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)killer;
                if (killer.m_214076_(serverLevel, entity)) {
                    InvigoratedEffect.onLivingDeath(serverLevel, entity, le);
                }
            }
        }
    }

    public static boolean isDayTime(Level level) {
        long dayTime = level.m_46468_() % 24000L;
        return dayTime > 500L && dayTime < 11500L;
    }
}

