/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.faster_ingredients;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import org.embeddedt.modernfix.forge.load.MinecraftServerReloadTracker;
import org.embeddedt.modernfix.forge.recipe.ExtendedIngredient;
import org.embeddedt.modernfix.forge.recipe.IngredientItemStacksSoftReference;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Ingredient.class}, priority=700)
public abstract class IngredientMixin
implements ExtendedIngredient {
    @Shadow
    @Final
    private Ingredient.Value[] f_43902_;
    @Shadow
    @Nullable
    private IntList f_43904_;
    @Shadow
    @Nullable
    private ItemStack[] f_43903_;
    private volatile IngredientItemStacksSoftReference mfix$cachedItemStacks;

    @Shadow
    public abstract boolean isVanilla();

    private boolean mfix$areTagsAvailable() {
        return !MinecraftServerReloadTracker.isReloadActive();
    }

    @Inject(method={"test(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/crafting/Ingredient;getItems()[Lnet/minecraft/world/item/ItemStack;")}, cancellable=true)
    private void modernfix$fasterTagIngredientTest(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        Ingredient.Value value;
        if (this.isVanilla() && this.f_43902_.length == 1 && (value = this.f_43902_[0]) instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            if (this.mfix$areTagsAvailable()) {
                cir.setReturnValue((Object)stack.m_220173_().m_203656_(tagValue.f_43959_));
            }
        }
    }

    @Override
    public boolean mfix$hasNoElements() {
        return !this.containsItems();
    }

    @Unique
    private boolean isEmptyTagStack(ItemStack item) {
        MutableComponent hoverName;
        Component component;
        return item.m_41720_() == Items.f_42127_ && (component = item.m_41786_()) instanceof MutableComponent && (hoverName = (MutableComponent)component).getString().startsWith("Empty Tag: ");
    }

    @Unique
    private boolean containsItems() {
        for (Ingredient.Value value : this.f_43902_) {
            Collection items;
            if (value instanceof Ingredient.ItemValue) {
                return true;
            }
            if (value instanceof Ingredient.TagValue) {
                Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                if (this.mfix$areTagsAvailable()) {
                    Optional holderSetOpt = BuiltInRegistries.f_257033_.m_203431_(tagValue.f_43959_);
                    if (!holderSetOpt.isPresent() || ((HolderSet.Named)holderSetOpt.get()).m_203632_() <= 0) continue;
                    return true;
                }
            }
            if ((items = value.m_6223_()).isEmpty() || this.isEmptyTagStack((ItemStack)items.iterator().next())) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"getStackingIds"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/crafting/Ingredient;getItems()[Lnet/minecraft/world/item/ItemStack;")}, cancellable=true)
    private void modernfix$fasterTagIngredientStacking(CallbackInfoReturnable<IntList> cir) {
        Ingredient.Value value;
        if (this.isVanilla() && this.f_43902_.length == 1 && (value = this.f_43902_[0]) instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            if (this.mfix$areTagsAvailable()) {
                Optional tag = BuiltInRegistries.f_257033_.m_203431_(tagValue.f_43959_);
                if (!tag.isPresent() || ((HolderSet.Named)tag.get()).m_203632_() == 0) {
                    return;
                }
                IntArrayList list = new IntArrayList(((HolderSet.Named)tag.get()).m_203614_().mapToInt(h -> BuiltInRegistries.f_257033_.m_7447_((Object)((Item)h.m_203334_()))).toArray());
                list.sort(IntComparators.NATURAL_COMPARATOR);
                this.f_43904_ = list;
                cir.setReturnValue((Object)list);
            }
        }
    }

    @Overwrite
    public ItemStack[] m_43908_() {
        ItemStack[] stacks;
        if (this.f_43903_ != null) {
            return this.f_43903_;
        }
        IngredientItemStacksSoftReference cache = this.mfix$cachedItemStacks;
        if (cache != null && (stacks = (ItemStack[])cache.get()) != null) {
            return stacks;
        }
        ItemStack[] result = this.computeItemsArray();
        this.mfix$cachedItemStacks = new IngredientItemStacksSoftReference((Ingredient)this, result);
        return result;
    }

    private ItemStack[] computeItemsArray() {
        if (this.f_43902_.length == 1) {
            Ingredient.Value value = this.f_43902_[0];
            if (value instanceof Ingredient.ItemValue) {
                Ingredient.ItemValue itemValue = (Ingredient.ItemValue)value;
                return new ItemStack[]{itemValue.f_43951_};
            }
            value = this.f_43902_[0];
            if (value instanceof Ingredient.TagValue) {
                Optional tag;
                Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                if (this.mfix$areTagsAvailable() && (tag = BuiltInRegistries.f_257033_.m_203431_(tagValue.f_43959_)).isPresent() && ((HolderSet.Named)tag.get()).m_203632_() > 0) {
                    HolderSet.Named holderSet = (HolderSet.Named)tag.get();
                    ItemStack[] result = new ItemStack[holderSet.m_203632_()];
                    for (int i = 0; i < result.length; ++i) {
                        result[i] = new ItemStack(holderSet.m_203662_(i));
                    }
                    return result;
                }
            }
        }
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(2);
        for (Ingredient.Value value : this.f_43902_) {
            Collection collection = value.m_6223_();
            itemList.ensureCapacity(collection.size() + itemList.size());
            for (ItemStack item : collection) {
                itemList.add(item);
            }
        }
        return (ItemStack[])itemList.toArray(ItemStack[]::new);
    }

    @Override
    public void mfix$clearReference() {
        this.mfix$cachedItemStacks = null;
    }
}

