/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.redstone.RedstoneAccess;

public class RedstoneMethods {
    private final RedstoneAccess redstone;

    public RedstoneMethods(RedstoneAccess redstone) {
        this.redstone = redstone;
    }

    @LuaFunction
    public final void setOutput(ComputerSide side, boolean on) {
        this.redstone.setOutput(side, on ? 15 : 0);
    }

    @LuaFunction
    public final boolean getOutput(ComputerSide side) {
        return this.redstone.getOutput(side) > 0;
    }

    @LuaFunction
    public final boolean getInput(ComputerSide side) {
        return this.redstone.getInput(side) > 0;
    }

    @LuaFunction(value={"setAnalogOutput", "setAnalogueOutput"})
    public final void setAnalogOutput(ComputerSide side, int value) throws LuaException {
        if (value < 0 || value > 15) {
            throw new LuaException("Expected number in range 0-15");
        }
        this.redstone.setOutput(side, value);
    }

    @LuaFunction(value={"getAnalogOutput", "getAnalogueOutput"})
    public final int getAnalogOutput(ComputerSide side) {
        return this.redstone.getOutput(side);
    }

    @LuaFunction(value={"getAnalogInput", "getAnalogueInput"})
    public final int getAnalogInput(ComputerSide side) {
        return this.redstone.getInput(side);
    }

    @LuaFunction
    public final void setBundledOutput(ComputerSide side, int output) {
        this.redstone.setBundledOutput(side, output);
    }

    @LuaFunction
    public final int getBundledOutput(ComputerSide side) {
        return this.redstone.getBundledOutput(side);
    }

    @LuaFunction
    public final int getBundledInput(ComputerSide side) {
        return this.redstone.getBundledInput(side);
    }

    @LuaFunction
    public final boolean testBundledInput(ComputerSide side, int mask) {
        int input = this.redstone.getBundledInput(side);
        return (input & mask) == mask;
    }
}

