/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog;

import com.hidoni.transmog.Constants;
import com.hidoni.transmog.RenderUtils;
import com.hidoni.transmog.config.Config;
import com.hidoni.transmog.registry.ModItems;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TransmogUtils {
    private static boolean notInPvP = true;
    private static Thread pvpTimerThread = null;
    private static final int MAX_CACHE_ENTRIES = 100;
    private static final Map<Integer, ItemStack> TRANSMOG_ITEM_CACHE = new LinkedHashMap<Integer, ItemStack>(100, 0.75f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry<Integer, ItemStack> eldest) {
            return this.size() > 101;
        }
    };

    public static void startPvP() {
        if (Config.pvpDisableDuration > 0) {
            TransmogUtils.setNotInPvP(false);
            if (pvpTimerThread != null) {
                Constants.LOG.info("Client player still involved in PvP, Extending transmog disable for another {} seconds", (Object)Config.pvpDisableDuration);
                Constants.LOG.debug("Interrupting existing PvP timer thread: {}", (Object)pvpTimerThread);
                pvpTimerThread.interrupt();
            } else {
                Constants.LOG.info("Client player involved in PvP, Disabling transmogs for {} seconds", (Object)Config.pvpDisableDuration);
            }
            pvpTimerThread = new Thread(() -> {
                try {
                    TimeUnit.SECONDS.sleep(Config.pvpDisableDuration);
                    TransmogUtils.setNotInPvP(true);
                    Constants.LOG.info("PvP Timer finished, Transmog re-enabled.");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            pvpTimerThread.start();
            Constants.LOG.debug("Created new PvP timer thread: {}", (Object)pvpTimerThread);
        }
    }

    private static synchronized void setNotInPvP(boolean notInPvP) {
        TransmogUtils.notInPvP = notInPvP;
    }

    public static boolean isItemStackTransmogged(ItemStack itemStack) {
        return itemStack.m_41737_("transmog:transmogItem") != null;
    }

    public static boolean isHiddenItem(ItemStack appearanceItem) {
        return appearanceItem.m_150930_((Item)ModItems.VOID_FRAGMENT.get());
    }

    public static ItemStack getAppearanceStackFromTag(@NotNull CompoundTag transmogTag) {
        return ItemStack.m_41712_((CompoundTag)transmogTag);
    }

    public static void transmogAppearanceOntoItemStack(ItemStack appearanceItem, ItemStack itemToTransmog) {
        itemToTransmog.m_41700_("transmog:transmogItem", (Tag)appearanceItem.m_41739_(new CompoundTag()));
    }

    public static ItemStack getAppearanceItemStack(ItemStack itemStack, boolean keepHiddenItem) {
        CompoundTag transmogTag = itemStack.m_41737_("transmog:transmogItem");
        if (transmogTag == null || itemStack.m_41619_()) {
            return itemStack;
        }
        ItemStack appearanceItem = TRANSMOG_ITEM_CACHE.computeIfAbsent(transmogTag.hashCode(), unused -> TransmogUtils.getAppearanceStackFromTag(transmogTag));
        if (!keepHiddenItem && TransmogUtils.isHiddenItem(appearanceItem)) {
            return ItemStack.f_41583_;
        }
        return appearanceItem;
    }

    public static ItemStack getAppearanceStackOrOriginal(ItemStack itemStack) {
        if (notInPvP && Config.renderOption.renderInWorld && TransmogUtils.isItemStackTransmogged(itemStack)) {
            if (!RenderUtils.isCalledForInventory()) {
                return TransmogUtils.getAppearanceItemStack(itemStack, false);
            }
            if (Config.renderOption.renderInInventory) {
                ItemStack appearanceItemStack = TransmogUtils.getAppearanceItemStack(itemStack, true);
                if (TransmogUtils.isHiddenItem(appearanceItemStack)) {
                    return itemStack;
                }
                appearanceItemStack.m_41764_(itemStack.m_41613_());
                return appearanceItemStack;
            }
        }
        return itemStack;
    }
}

