/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.EnumMap;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import ovh.corail.tombstone.helper.Helper;

public enum GraveModel implements StringRepresentable
{
    GRAVE_SIMPLE("grave_simple"),
    GRAVE_NORMAL("grave_normal"),
    GRAVE_CROSS("grave_cross"),
    TOMBSTONE("tombstone"),
    SUBARAKI_GRAVE("subaraki_grave"),
    GRAVE_ORIGINAL("grave_original");

    private final String name;
    private final EnumMap<Direction, VoxelShape> collisions = new EnumMap(Direction.class);
    private static final VoxelShape GROUND_BOUNDS;

    private GraveModel(String name) {
        this.name = name;
    }

    public GraveModel getPrevious() {
        return GraveModel.byId(this.ordinal() > 0 ? this.ordinal() - 1 : GraveModel.values().length - 1);
    }

    public GraveModel getNext() {
        return GraveModel.byId(this.ordinal() == GraveModel.values().length - 1 ? 0 : this.ordinal() + 1);
    }

    public final VoxelShape getShape(Direction direction) {
        return this.collisions.computeIfAbsent(direction, this::getShapeBounds);
    }

    public static GraveModel byId(int id) {
        return id >= 0 && id < GraveModel.values().length ? GraveModel.values()[id] : GraveModel.getDefault();
    }

    public static GraveModel getDefault() {
        return GRAVE_SIMPLE;
    }

    public String m_7912_() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    private VoxelShape getShapeBounds(Direction direction) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case GRAVE_NORMAL -> Shapes.m_83124_((VoxelShape)GROUND_BOUNDS, (VoxelShape[])new VoxelShape[]{Helper.createShapeForDirection(direction, 0.1875, 0.0625, 0.0, 0.8125, 0.25, 1.0), Helper.createShapeForDirection(direction, 0.25, 0.25, 0.0625, 0.75, 0.3125, 0.875), Helper.createShapeForDirection(direction, 0.1875, 0.25, 0.875, 0.8125, 0.8125, 1.0), Helper.createShapeForDirection(direction, 0.25, 0.8125, 0.875, 0.75, 0.875, 1.0)});
            case GRAVE_CROSS -> Shapes.m_83124_((VoxelShape)GROUND_BOUNDS, (VoxelShape[])new VoxelShape[]{Helper.createShapeForDirection(direction, 0.40625, 0.125, 0.6875, 0.59375, 0.9375, 0.875), Helper.createShapeForDirection(direction, 0.21875, 0.5625, 0.6875, 0.78125, 0.75, 0.875), Helper.createShapeForDirection(direction, 0.28125, 0.0625, 0.5625, 0.71875, 0.125, 1.0), Helper.createShapeForDirection(direction, 0.34375, 0.125, 0.625, 0.65625, 0.1875, 0.9375)});
            case TOMBSTONE -> Shapes.m_83124_((VoxelShape)GROUND_BOUNDS, (VoxelShape[])new VoxelShape[]{Helper.createShapeForDirection(direction, 0.0625, 0.0625, 0.0625, 0.9375, 0.09375, 0.4375), Helper.createShapeForDirection(direction, 0.0625, 0.09375, 0.1875, 0.9375, 0.125, 0.4375), Helper.createShapeForDirection(direction, 0.84375, 0.125, 0.28125, 0.90625, 0.59375, 0.34375), Helper.createShapeForDirection(direction, 0.09375, 0.125, 0.28125, 0.15625, 0.59375, 0.34375), Helper.createShapeForDirection(direction, 0.0625, 0.0625, 0.4375, 0.9375, 0.59375, 0.9375), Helper.createShapeForDirection(direction, 0.03125, 0.59375, 0.21875, 0.96875, 0.625, 0.96875), Helper.createShapeForDirection(direction, 0.0625, 0.625, 0.25, 0.9375, 0.64375, 0.9375)});
            case SUBARAKI_GRAVE -> Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.9375), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.125, (double)0.0625, (double)0.125, (double)0.875, (double)0.125, (double)0.875), Shapes.m_83048_((double)0.25, (double)0.125, (double)0.25, (double)0.75, (double)0.375, (double)0.75), Shapes.m_83048_((double)0.1875, (double)0.375, (double)0.1875, (double)0.8125, (double)0.4375, (double)0.8125), Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)0.1875, (double)0.125), Shapes.m_83048_((double)0.875, (double)0.0, (double)0.875, (double)1.0, (double)0.1875, (double)1.0), Shapes.m_83048_((double)0.0, (double)0.0, (double)0.875, (double)0.125, (double)0.1875, (double)1.0), Shapes.m_83048_((double)0.875, (double)0.0, (double)0.0, (double)1.0, (double)0.1875, (double)0.125), Helper.createShapeForDirection(direction, 0.25, 0.4375, 0.375, 0.75, 0.9375, 0.625)});
            case GRAVE_ORIGINAL -> Shapes.m_83124_((VoxelShape)GROUND_BOUNDS, (VoxelShape[])new VoxelShape[]{Helper.createShapeForDirection(direction, 0.15625, 0.0625, 0.0, 0.84375, 0.09375, 1.0), Helper.createShapeForDirection(direction, 0.28125, 0.09375, 0.03125, 0.71875, 0.46875, 0.96875), Helper.createShapeForDirection(direction, 0.40625, 0.46875, 0.71875, 0.59375, 0.5, 0.90625), Helper.createShapeForDirection(direction, 0.453125, 0.5, 0.765625, 0.546875, 0.625, 0.859375), Helper.createShapeForDirection(direction, 0.484375, 0.625, 0.796875, 0.515625, 0.875, 0.828125), Helper.createShapeForDirection(direction, 0.421875, 0.78125, 0.796875, 0.578125, 0.8125, 0.828125), Helper.createShapeForDirection(direction, 0.453125, 0.75, 0.796875, 0.546875, 0.84375, 0.828125)});
            case GRAVE_SIMPLE -> Shapes.m_83124_((VoxelShape)GROUND_BOUNDS, (VoxelShape[])new VoxelShape[]{Helper.createShapeForDirection(direction, 0.1875, 0.0625, 0.8125, 0.8125, 0.8125, 1.0), Helper.createShapeForDirection(direction, 0.25, 0.8125, 0.8125, 0.75, 0.875, 1.0)});
        };
    }

    static {
        GROUND_BOUNDS = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
    }
}

