/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.CMessageTBCapability;
import ovh.corail.tombstone.network.PacketHandler;

public class CommandTBAlignment
extends TombstoneCommand {
    private static final SuggestionProvider<CommandSourceStack> ALIGNMENT_SUGGESTION = (ctx, build) -> SharedSuggestionProvider.m_82981_(IntStream.rangeClosed(-4, 4).mapToObj(String::valueOf), (SuggestionsBuilder)build);
    private static final int MAX_ALIGNMENT_VALUE = 5000;
    private static final SuggestionProvider<CommandSourceStack> ALIGNMENT_AMOUNT_SUGGESTION = (ctx, build) -> build.suggest(1, () -> "[1-5000]").buildFuture();

    @Override
    protected TombstoneCommand.CommandName getCommandName() {
        return TombstoneCommand.CommandName.ALIGNMENT;
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder, CommandBuildContext buildContext) {
        builder.executes(this::showUsage);
        builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::showAlignment)).then(SubCommand.SHOW.literal().executes(this::showAlignment))).then(((LiteralArgumentBuilder)SubCommand.SET.literal().executes(this::showUsage)).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)-4, (int)4)).suggests(ALIGNMENT_SUGGESTION).executes(this::setAlignment)))).then(((LiteralArgumentBuilder)SubCommand.INCREASE.literal().executes(this::showUsage)).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests(ALIGNMENT_AMOUNT_SUGGESTION).executes(this::increaseAlignment)))).then(((LiteralArgumentBuilder)SubCommand.DECREASE.literal().executes(this::showUsage)).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests(ALIGNMENT_AMOUNT_SUGGESTION).executes(this::decreaseAlignment))));
        return builder;
    }

    private int showAlignment(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        target.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
            int alignmentLevel = cap.getAlignmentLevel();
            MutableComponent alignmentText = alignmentLevel == 0 ? LangKey.MESSAGE_NEUTRAL.getText(new Object[0]) : (alignmentLevel < 0 ? LangKey.MESSAGE_DARKNESS : LangKey.MESSAGE_LIGHT).getText(ChatFormatting.BOLD, new Object[]{Helper.getRomanNumber(Math.abs(alignmentLevel))});
            this.sendMessage((CommandSourceStack)ctx.getSource(), LangKey.MESSAGE_SHOW_ALIGNMENT.getText(StyleType.MESSAGE_SPELL, new Object[]{target.m_7755_(), alignmentText, cap.getAlignmentValue()}), false);
        });
        return 1;
    }

    private int setAlignment(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        int alignment = (new int[]{-5000, -3000, -1500, -500, 0, 500, 1500, 3000, 5000})[Mth.m_14045_((int)IntegerArgumentType.getInteger(ctx, (String)"amount"), (int)-4, (int)4) + 4];
        target.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.setAlignment(alignment));
        PacketHandler.sendToPlayer(new CMessageTBCapability(CMessageTBCapability.SyncType.ALIGNMENT, alignment), target);
        this.sendMessage((CommandSourceStack)ctx.getSource(), LangKey.MESSAGE_SET_ALIGNMENT.getText(target.m_7755_()), false);
        return 1;
    }

    private int increaseAlignment(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return this.modifyAlignment(ctx, true);
    }

    private int decreaseAlignment(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return this.modifyAlignment(ctx, false);
    }

    private int modifyAlignment(CommandContext<CommandSourceStack> ctx, boolean increase) throws CommandSyntaxException {
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        if (amount < 0) {
            throw LangKey.MESSAGE_POSITIVE_INTEGER.asCommandException(new Object[0]);
        }
        if (amount == 0 || amount > 5000) {
            throw LangKey.MESSAGE_INVALID_VALUE.asCommandException(new Object[0]);
        }
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        target.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.rewardAlignment(target, increase ? amount : -amount));
        if (!target.equals((Object)((CommandSourceStack)ctx.getSource()).m_81373_()) || !PlayerPreference.get(target).displayAlignmentMessage()) {
            this.sendMessage((CommandSourceStack)ctx.getSource(), (increase ? LangKey.MESSAGE_INCREASE_OF : LangKey.MESSAGE_DECREASE_OF).getText(LangKey.MESSAGE_PLAYER_ALIGNMENT.getText(target.m_7755_()), amount), false);
        }
        return 1;
    }

    private static enum SubCommand implements ISubCommand
    {
        SHOW,
        SET,
        INCREASE,
        DECREASE;

    }
}

