/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.config.ConfigTombstone;

public final class TimeHelper {
    public static long SERVER_START_TIME;
    private static SpecialEvent SPECIAL_EVENT;
    private static final String[] UNITY;

    public static void init() {
        SERVER_START_TIME = TimeHelper.systemTime();
        LocalDate date = LocalDate.now();
        if (date.get(ChronoField.MONTH_OF_YEAR) == 3 && date.get(ChronoField.DAY_OF_MONTH) >= 21 || date.get(ChronoField.MONTH_OF_YEAR) == 4 && date.get(ChronoField.DAY_OF_MONTH) <= 21) {
            SPECIAL_EVENT = (Boolean)ConfigTombstone.special_events.allowAprilFools.get() != false && date.get(ChronoField.MONTH_OF_YEAR) == 4 && date.get(ChronoField.DAY_OF_MONTH) == 1 ? SpecialEvent.APRIL_FOOLS : ((Boolean)ConfigTombstone.special_events.allowEaster.get() != false ? SpecialEvent.EASTER : SpecialEvent.NONE);
        } else if (date.get(ChronoField.MONTH_OF_YEAR) == 10 && date.get(ChronoField.DAY_OF_MONTH) >= 20 || date.get(ChronoField.MONTH_OF_YEAR) == 11 && date.get(ChronoField.DAY_OF_MONTH) <= 3) {
            SPECIAL_EVENT = (Boolean)ConfigTombstone.special_events.allowHalloween.get() != false ? SpecialEvent.HALLOWEEN : SpecialEvent.NONE;
        } else if (date.get(ChronoField.MONTH_OF_YEAR) == 12 && date.get(ChronoField.DAY_OF_MONTH) >= 6) {
            SPECIAL_EVENT = (Boolean)ConfigTombstone.special_events.allowChristmas.get() != false ? SpecialEvent.CHRISTMAS : SpecialEvent.NONE;
        }
    }

    public static long systemTime() {
        return System.currentTimeMillis();
    }

    public static SpecialEvent getSpecialEvent() {
        return SPECIAL_EVENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setSpecialEvent(SpecialEvent event) {
        SPECIAL_EVENT = event;
    }

    public static boolean isAprilFoolsDay() {
        return SPECIAL_EVENT == SpecialEvent.APRIL_FOOLS;
    }

    public static boolean isDateAroundHalloween() {
        return SPECIAL_EVENT == SpecialEvent.HALLOWEEN;
    }

    public static boolean isDateAroundChristmas() {
        return SPECIAL_EVENT == SpecialEvent.CHRISTMAS;
    }

    public static boolean isDateAroundEaster() {
        return SPECIAL_EVENT == SpecialEvent.EASTER;
    }

    public static long worldTicks(Level level) {
        return level.m_46467_();
    }

    public static int tickFromSecond(int second) {
        return second * 20;
    }

    public static int tickFromMinute(int minute) {
        return minute * 1200;
    }

    public static int tickFromHour(int hour) {
        return hour * 72000;
    }

    public static int tickFromDay(int day) {
        return day * 1728000;
    }

    public static boolean atInterval(Entity entity, int tick) {
        return TimeHelper.atInterval(entity.f_19797_, tick);
    }

    public static boolean atInterval(Level level, int tick) {
        return TimeHelper.atInterval(TimeHelper.worldTicks(level), tick);
    }

    public static boolean atInterval(long ticksExisted, int tick) {
        return TimeHelper.testInterval(ticksExisted, tick, interval -> interval == 0L);
    }

    public static boolean inIntervalBefore(long ticksExisted, int tick, int intervalStart) {
        return TimeHelper.testInterval(ticksExisted, tick, interval -> interval < (long)intervalStart);
    }

    public static boolean inIntervalAfter(long ticksExisted, int tick, int intervalStart) {
        return TimeHelper.testInterval(ticksExisted, tick, interval -> interval > (long)intervalStart);
    }

    public static boolean testInterval(long ticksExisted, int tick, Predicate<Long> intervalPredic) {
        return ticksExisted > 0L && intervalPredic.test(ticksExisted % (long)tick);
    }

    public static long minuteElapsed(Level level, long oldTime) {
        return TimeHelper.minuteElapsed(TimeHelper.worldTicks(level), oldTime);
    }

    public static long minuteElapsed(long nowTime, long oldTime) {
        return (nowTime - oldTime) / 1200L;
    }

    public static boolean isMinuteElapsed(Level level, long oldTime, int minute) {
        return TimeHelper.isMinuteElapsed(TimeHelper.worldTicks(level), oldTime, minute);
    }

    public static boolean isMinuteElapsed(long nowTime, long oldTime, int minute) {
        return nowTime - oldTime >= (long)TimeHelper.tickFromMinute(minute);
    }

    public static String getTimeString(int cd) {
        return TimeHelper.getTimeString(cd, i -> ":", false);
    }

    public static String getTimeStringWithUnit(int cd) {
        return TimeHelper.getTimeString(cd, i -> UNITY[i], true);
    }

    private static String getTimeString(int cd, Function<Integer, String> separator, boolean separatorAtEnd) {
        int[] timeArray = TimeHelper.getTimeArray(cd);
        StringBuilder builder = new StringBuilder();
        int start = IntStream.range(0, timeArray.length).filter(i -> timeArray[i] > 0).findFirst().orElse(timeArray.length - 1);
        IntStream.range(start, timeArray.length - 1).forEach(unit -> {
            builder.append(String.format(Locale.US, "%02d", timeArray[unit]));
            builder.append((String)separator.apply(unit));
        });
        builder.append(String.format(Locale.US, "%02d", timeArray[timeArray.length - 1]));
        if (separatorAtEnd) {
            builder.append(separator.apply(timeArray.length - 1));
        }
        return builder.toString();
    }

    private static int[] getTimeArray(int cd) {
        int[] timeArray = new int[]{0, 0, 0, 0};
        if (cd >= 1728000) {
            timeArray[0] = cd / 1728000;
            cd -= timeArray[0] * 1728000;
        }
        if (cd >= 72000) {
            timeArray[1] = cd / 72000;
            cd -= timeArray[1] * 72000;
        }
        if (cd >= 1200) {
            timeArray[2] = cd / 1200;
            cd -= timeArray[2] * 1200;
        }
        if (cd >= 20) {
            timeArray[3] = cd / 20;
        }
        return timeArray;
    }

    public static float flicker(int age, int maxAge) {
        return Mth.m_14031_((float)((float)Math.PI * ((float)age / (float)maxAge)));
    }

    public static float rise(int age, int maxAge) {
        return Mth.m_14031_((float)(1.5707964f * ((float)age / (float)maxAge)));
    }

    public static float downfall(int age, int maxAge) {
        return Mth.m_14089_((float)(1.5707964f * ((float)age / (float)maxAge)));
    }

    static {
        SPECIAL_EVENT = SpecialEvent.NONE;
        UNITY = new String[]{"d", "h", "m", "s"};
    }

    public static enum SpecialEvent {
        NONE,
        APRIL_FOOLS,
        HALLOWEEN,
        CHRISTMAS,
        EASTER;


        public static SpecialEvent byId(int id) {
            if (id > 0 && id < SpecialEvent.values().length) {
                return SpecialEvent.values()[id];
            }
            return NONE;
        }
    }
}

