/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.extern.epicfight;

import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.stamina.ParCoolStamina;
import com.alrex.parcool.extern.ModManager;
import com.alrex.parcool.extern.epicfight.EpicFightStamina;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class EpicFightManager
extends ModManager {
    public EpicFightManager() {
        super("epicfight");
    }

    public IStamina newFeathersStaminaFor(Player player) {
        if (!this.isInstalled()) {
            return IStamina.Type.Default.newInstance(player);
        }
        return new EpicFightStamina(player);
    }

    @Nullable
    PlayerPatch<?> getPlayerPatch(Player player) {
        if (!this.isInstalled()) {
            return null;
        }
        return (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
    }

    public boolean isBattleMode(Player player) {
        PlayerPatch<?> patch = this.getPlayerPatch(player);
        if (patch == null) {
            return false;
        }
        return patch.isBattleMode();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canShowStaminaHUD(Player player) {
        IStamina stamina = IStamina.get(player);
        if (stamina instanceof ParCoolStamina) {
            return true;
        }
        return stamina instanceof EpicFightStamina && !this.isBattleMode(player);
    }
}

