/*
 * Decompiled with CFR 0.152.
 */
package com.vkv.serveritemgone;

import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.vkv.serveritemgone.commands.SIGCommands;
import com.vkv.serveritemgone.utils.Blacklist;
import com.vkv.serveritemgone.utils.JsonUtils;
import java.io.File;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="serveritemgone")
public class ServerItemGone {
    public static final String MODID = "serveritemgone";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static File BLACKLIST_FILE = null;
    public static Blacklist BLACKLIST = Blacklist.emptyBlacklist();
    public static JsonOps MODIFIED_JSON_OPS = new JsonOps(false){

        public <U> U convertTo(DynamicOps<U> outOps, JsonElement input) {
            if (input == null) {
                return (U)outOps.empty();
            }
            return (U)super.convertTo(outOps, input);
        }
    };

    public ServerItemGone() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onDeath(LivingDropsEvent event) {
        event.getDrops().removeIf(itemEntity -> ServerItemGone.isBanned(itemEntity.m_32055_()));
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        SIGCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        Path modFolder = event.getServer().m_129843_(new LevelResource("serverconfig"));
        BLACKLIST_FILE = JsonUtils.initialize(modFolder, "itemblacklist.json", (RegistryAccess)event.getServer().m_206579_());
        BLACKLIST = JsonUtils.readFromJson(BLACKLIST_FILE, (RegistryAccess)event.getServer().m_206579_());
    }

    @SubscribeEvent
    public void onServerSave(LevelEvent.Save event) {
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && (level = (Level)levelAccessor).m_46472_() == level.m_7654_().m_129783_().m_46472_()) {
            JsonUtils.writeJson(BLACKLIST_FILE, BLACKLIST, event.getLevel().m_9598_());
        }
    }

    public static boolean isBanned(@Nullable ItemStack stack) {
        return ServerItemGone.isBanned(stack, null);
    }

    public static boolean isBanned(@Nullable ItemStack stack, @Nullable Player player) {
        return BLACKLIST.shouldBan(stack, player);
    }
}

