/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class BaseElectricBlockEntity
extends SmartBlockEntity {
    protected final InternalEnergyStorage localEnergy;
    protected LazyOptional<IEnergyStorage> lazyEnergy;
    private EnumSet<Direction> invalidSides = EnumSet.allOf(Direction.class);
    private EnumMap<Direction, LazyOptional<IEnergyStorage>> escacheMap = new EnumMap(Direction.class);

    public BaseElectricBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.localEnergy = new InternalEnergyStorage(this.getCapacity(), this.getMaxIn(), this.getMaxOut());
        this.lazyEnergy = LazyOptional.of(() -> this.localEnergy);
        this.setLazyTickRate(20);
    }

    public abstract int getCapacity();

    public abstract int getMaxIn();

    public abstract int getMaxOut();

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && (this.isEnergyInput(side) || this.isEnergyOutput(side))) {
            return this.lazyEnergy.cast();
        }
        return super.getCapability(cap, side);
    }

    public abstract boolean isEnergyInput(Direction var1);

    public abstract boolean isEnergyOutput(Direction var1);

    protected void read(CompoundTag compound, boolean arg1) {
        super.read(compound, arg1);
        this.localEnergy.read(compound);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.localEnergy.write(compound);
    }

    public void remove() {
        this.lazyEnergy.invalidate();
    }

    @Deprecated
    public void outputTick(int max) {
        for (Direction side : Direction.values()) {
            if (!this.isEnergyOutput(side)) continue;
            this.localEnergy.outputToSide(this.f_58857_, this.f_58858_, side, max);
        }
    }

    public void tick() {
        super.tick();
        if (!this.invalidSides.isEmpty()) {
            this.invalidSides.forEach(this::updateCache);
            this.invalidSides.clear();
        }
    }

    public boolean ignoreCapSide() {
        return false;
    }

    private void invalidCache(Direction side) {
        this.invalidSides.add(side);
    }

    public void updateCache() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        for (Direction side : Direction.values()) {
            this.updateCache(side);
        }
    }

    public void updateCache(Direction side) {
        if (!this.f_58857_.m_46749_(this.f_58858_.m_121945_(side))) {
            this.setCache(side, (LazyOptional<IEnergyStorage>)LazyOptional.empty());
            return;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side));
        if (te == null) {
            this.setCache(side, (LazyOptional<IEnergyStorage>)LazyOptional.empty());
            return;
        }
        LazyOptional le = te.getCapability(ForgeCapabilities.ENERGY, side.m_122424_());
        if (this.ignoreCapSide() && !le.isPresent()) {
            le = te.getCapability(ForgeCapabilities.ENERGY);
        }
        if (le.equals(this.getCachedEnergy(side))) {
            return;
        }
        this.setCache(side, (LazyOptional<IEnergyStorage>)le);
        le.addListener(es -> this.invalidCache(side));
    }

    public void setCache(Direction side, LazyOptional<IEnergyStorage> storage) {
        this.escacheMap.put(side, storage);
    }

    public LazyOptional<IEnergyStorage> getCachedEnergy(Direction side) {
        return this.escacheMap.getOrDefault(side, (LazyOptional<IEnergyStorage>)LazyOptional.empty());
    }
}

