/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.blocks.connector.ConnectorType;
import com.mrh0.createaddition.energy.LocalNode;
import com.mrh0.createaddition.energy.WireConnectResult;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CAItems;
import com.mrh0.createaddition.item.WireSpool;
import com.mrh0.createaddition.util.Util;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IWireNode {
    @Nullable
    public IWireNode getWireNode(int var1);

    @Nullable
    public static IWireNode getWireNodeFrom(int index, IWireNode obj, LocalNode[] localNodes, IWireNode[] nodeCache, Level level) {
        if (!obj.hasConnection(index)) {
            return null;
        }
        if (nodeCache[index] == null) {
            nodeCache[index] = IWireNode.getWireNode(level, localNodes[index].getPos());
        }
        if (nodeCache[index] == null) {
            obj.removeNode(index);
        }
        return nodeCache[index];
    }

    @Nullable
    public LocalNode getLocalNode(int var1);

    public void setNode(int var1, int var2, BlockPos var3, WireType var4);

    public void removeNode(int var1, boolean var2);

    default public void removeNode(int index) {
        this.removeNode(index, false);
    }

    default public void removeNode(LocalNode node, boolean dropWire) {
        this.removeNode(node.getIndex(), dropWire);
    }

    default public void removeNode(@NotNull LocalNode node) {
        this.removeNode(node.getIndex());
    }

    default public int getNodeCount() {
        return 1;
    }

    default public int getAvailableNode(Vec3 pos) {
        return this.getAvailableNode();
    }

    default public int getAvailableNode() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    default public BlockPos getNodePos(int index) {
        LocalNode node = this.getLocalNode(index);
        if (node == null) {
            return null;
        }
        return node.getPos();
    }

    @Nullable
    default public WireType getNodeType(int index) {
        LocalNode node = this.getLocalNode(index);
        if (node == null) {
            return null;
        }
        return node.getType();
    }

    default public int getOtherNodeIndex(int index) {
        LocalNode node = this.getLocalNode(index);
        if (node == null) {
            return -1;
        }
        return node.getOtherIndex();
    }

    default public boolean hasConnection(int index) {
        return this.getLocalNode(index) != null;
    }

    default public boolean hasAnyConnection() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (!this.hasConnection(i)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasConnectionTo(BlockPos pos) {
        if (pos == null) {
            return false;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode node = this.getLocalNode(i);
            if (node == null || !node.getPos().equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public LocalNode getConnectionTo(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode node = this.getLocalNode(i);
            if (node == null || !node.getPos().equals((Object)pos)) continue;
            return node;
        }
        return null;
    }

    default public boolean isNodeInput(int index) {
        return true;
    }

    default public boolean isNodeOutput(int node) {
        return true;
    }

    public Vec3 getNodeOffset(int var1);

    public BlockPos getPos();

    public void invalidateNodeCache();

    public void setNetwork(int var1, EnergyNetwork var2);

    public EnergyNetwork getNetwork(int var1);

    default public boolean awakeNetwork(Level world) {
        boolean b = false;
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.isNetworkValid(i)) continue;
            this.setNetwork(i, EnergyNetwork.nextNode(world, new EnergyNetwork(world), new HashMap<String, IWireNode>(), this, i));
            b = true;
        }
        return b;
    }

    default public boolean isNetworkValid(int node) {
        if (this.getNetwork(node) == null) {
            return false;
        }
        return this.getNetwork(node).isValid();
    }

    default public boolean isNodeIndeciesConnected(int in, int other) {
        return true;
    }

    default public boolean validateLocalNodes(LocalNode[] localNodes) {
        boolean changed = false;
        for (int i = 0; i < this.getNodeCount(); ++i) {
            IWireNode otherNode;
            if (localNodes[i] == null || (otherNode = this.getWireNode(i)) == null || otherNode.hasConnectionTo(this.getPos())) continue;
            changed = true;
            localNodes[i] = null;
        }
        return changed;
    }

    default public void convertOldNbt(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (!nbt.m_128441_("node" + i)) continue;
            if (nbt.m_128451_("node" + i) == -1) {
                nbt.m_128473_("node" + i);
                nbt.m_128473_("type" + i);
                continue;
            }
            int other = nbt.m_128451_("node" + i);
            WireType type = WireType.fromIndex(nbt.m_128451_("type" + i));
            BlockPos pos = new BlockPos(nbt.m_128451_("x" + i), nbt.m_128451_("y" + i), nbt.m_128451_("z" + i)).m_121996_((Vec3i)this.getPos());
            nbt.m_128473_("node" + i);
            nbt.m_128473_("type" + i);
            nbt.m_128473_("x" + i);
            nbt.m_128473_("y" + i);
            nbt.m_128473_("z" + i);
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("id", i);
            tag.m_128405_("other", other);
            tag.m_128405_("type", type.getIndex());
            tag.m_128405_("x", pos.m_123341_());
            tag.m_128405_("y", pos.m_123342_());
            tag.m_128405_("z", pos.m_123343_());
            list.add((Object)tag);
        }
        nbt.m_128365_("nodes", (Tag)list);
    }

    default public void handleWireCache(Level level, Set<LocalNode> toDrop) {
        toDrop.forEach(node -> this.dropWire(level, (LocalNode)node));
        toDrop.clear();
    }

    default public void disconnectWires() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode node = this.getLocalNode(i);
            if (node == null) continue;
            node.invalid();
        }
    }

    default public void dropWire(Level world, LocalNode node) {
        WireType type = node.getType();
        ItemStack wire = type.getDrop();
        node.invalid();
        IWireNode.dropWire(world, this.getPos(), wire);
    }

    default public void dropWires(Level world, boolean dropItems) {
        if (!dropItems) {
            this.disconnectWires();
            return;
        }
        NonNullList wires = NonNullList.m_122780_((int)WireType.values().length, (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode node = this.getLocalNode(i);
            if (node == null) continue;
            WireType type = node.getType();
            int index = type.getIndex();
            if (((ItemStack)wires.get(index)).m_41619_()) {
                wires.set(index, (Object)type.getDrop());
            } else {
                ((ItemStack)wires.get(index)).m_41769_(type.getDrop().m_41613_());
            }
            node.invalid();
        }
        for (ItemStack stack : wires) {
            IWireNode.dropWire(world, this.getPos(), stack);
        }
    }

    default public void dropWires(Level world, Player player, boolean dropItems) {
        if (!dropItems) {
            this.disconnectWires();
            return;
        }
        NonNullList wireSpools = NonNullList.m_122780_((int)WireType.values().length, (Object)ItemStack.f_41583_);
        NonNullList wires = NonNullList.m_122780_((int)WireType.values().length, (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            LocalNode node = this.getLocalNode(i);
            if (node == null) continue;
            WireType type = node.getType();
            int index = type.getIndex();
            ItemStack spools = Util.findStack(((WireSpool)((Object)CAItems.SPOOL.get())).m_5456_(), player.m_150109_());
            if (spools.m_41613_() > 0) {
                if (((ItemStack)wireSpools.get(index)).m_41619_()) {
                    wireSpools.set(index, (Object)type.getSourceDrop());
                } else {
                    ((ItemStack)wireSpools.get(index)).m_41769_(type.getSourceDrop().m_41613_());
                }
                spools.m_41774_(1);
            } else if (((ItemStack)wires.get(index)).m_41619_()) {
                wires.set(index, (Object)type.getDrop());
            } else {
                ((ItemStack)wires.get(index)).m_41769_(type.getDrop().m_41613_());
            }
            node.invalid();
        }
        for (ItemStack stack : wireSpools) {
            if (stack.m_41619_()) continue;
            IWireNode.dropWire(world, this.getPos(), player.m_150109_().m_36054_(stack) ? ItemStack.f_41583_ : stack);
        }
        for (ItemStack stack : wires) {
            if (stack.m_41619_()) continue;
            IWireNode.dropWire(world, this.getPos(), player.m_150109_().m_36054_(stack) ? ItemStack.f_41583_ : stack);
        }
    }

    public ConnectorType getConnectorType();

    @Nullable
    public static BlockPos readNodeBlockPos(CompoundTag nbt, int index, BlockPos origin) {
        CompoundTag node = IWireNode.getNbtNode(nbt, index);
        if (node == null) {
            return null;
        }
        return origin.m_7918_(node.m_128451_("x"), node.m_128451_("y"), node.m_128451_("z"));
    }

    public static WireType readNodeWireType(CompoundTag nbt, int index) {
        CompoundTag node = IWireNode.getNbtNode(nbt, index);
        if (node == null) {
            return null;
        }
        return WireType.fromIndex(node.m_128451_("type"));
    }

    public static int readNodeOtherIndex(CompoundTag nbt, int index) {
        CompoundTag node = IWireNode.getNbtNode(nbt, index);
        if (node == null) {
            return -1;
        }
        return node.m_128451_("other");
    }

    @Nullable
    public static CompoundTag getNbtNode(CompoundTag nbt, int index) {
        if (!nbt.m_128441_("nodes")) {
            return null;
        }
        ListTag nodes = nbt.m_128437_("nodes", 10);
        for (Tag t : nodes) {
            CompoundTag node = (CompoundTag)t;
            if (node.m_128451_("id") != index) continue;
            return node;
        }
        return null;
    }

    public int getMaxWireLength();

    public static WireConnectResult connect(Level world, BlockPos pos1, int node1, BlockPos pos2, int node2, WireType type) {
        IWireNode wn1;
        BlockEntity te2;
        block9: {
            block8: {
                BlockEntity te1 = world.m_7702_(pos1);
                te2 = world.m_7702_(pos2);
                if (te1 == null || te2 == null || te1 == te2) {
                    return WireConnectResult.INVALID;
                }
                if (!(te1 instanceof IWireNode)) break block8;
                wn1 = (IWireNode)te1;
                if (te2 instanceof IWireNode) break block9;
            }
            return WireConnectResult.INVALID;
        }
        IWireNode wn2 = (IWireNode)te2;
        if (node1 < 0 || node2 < 0) {
            return WireConnectResult.COUNT;
        }
        int maxLength = Math.min(wn1.getMaxWireLength(), wn2.getMaxWireLength());
        if (pos1.m_123331_((Vec3i)pos2) > (double)(maxLength * maxLength)) {
            return WireConnectResult.LONG;
        }
        if (wn1.hasConnectionTo(pos2)) {
            return WireConnectResult.EXISTS;
        }
        if (wn1.getConnectorType() == ConnectorType.Large && wn2.getConnectorType() == ConnectorType.Large && type == WireType.COPPER) {
            return WireConnectResult.REQUIRES_HIGH_CURRENT;
        }
        wn1.setNode(node1, node2, wn2.getPos(), type);
        wn2.setNode(node2, node1, wn1.getPos(), type);
        return WireConnectResult.getLink(wn2.isNodeInput(node2), wn2.isNodeOutput(node2));
    }

    public static WireConnectResult disconnect(Level world, BlockPos pos1, BlockPos pos2) {
        IWireNode wn1;
        BlockEntity te2;
        block7: {
            block6: {
                BlockEntity te1 = world.m_7702_(pos1);
                te2 = world.m_7702_(pos2);
                if (te1 == null || te2 == null || te1 == te2) {
                    return WireConnectResult.INVALID;
                }
                if (!(te1 instanceof IWireNode)) break block6;
                wn1 = (IWireNode)te1;
                if (te2 instanceof IWireNode) break block7;
            }
            return WireConnectResult.INVALID;
        }
        IWireNode wn2 = (IWireNode)te2;
        if (!wn1.hasConnectionTo(pos2)) {
            return WireConnectResult.NO_CONNECTION;
        }
        LocalNode ln1 = wn1.getConnectionTo(pos2);
        LocalNode ln2 = wn2.getConnectionTo(pos1);
        if (ln1 == null || ln2 == null) {
            return WireConnectResult.NO_CONNECTION;
        }
        wn1.removeNode(ln1);
        wn2.removeNode(ln2);
        return WireConnectResult.REMOVED;
    }

    @Nullable
    public static WireType getTypeOfConnection(Level level, BlockPos pos1, BlockPos pos2) {
        BlockEntity te1 = level.m_7702_(pos1);
        if (te1 == null) {
            return null;
        }
        if (!(te1 instanceof IWireNode)) {
            return null;
        }
        IWireNode wn = (IWireNode)te1;
        LocalNode ln = wn.getConnectionTo(pos2);
        if (ln == null) {
            return null;
        }
        return ln.getType();
    }

    public static IWireNode getWireNode(Level level, BlockPos pos) {
        if (pos == null) {
            return null;
        }
        BlockEntity te = level.m_7702_(pos);
        if (te == null) {
            return null;
        }
        if (!(te instanceof IWireNode)) {
            return null;
        }
        return (IWireNode)te;
    }

    public static void dropWire(Level world, BlockPos pos, ItemStack stack) {
        Containers.m_19010_((Level)world, (BlockPos)pos, (NonNullList)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{stack}));
    }
}

