/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.connection;

import com.enderio.api.UseOnly;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.SlotType;
import com.enderio.api.misc.ColorControl;
import com.enderio.api.misc.RedstoneControl;
import com.enderio.conduits.common.conduit.connection.ConnectionState;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;

public record DynamicConnectionState(boolean isInsert, ColorControl insertChannel, boolean isExtract, ColorControl extractChannel, RedstoneControl control, ColorControl redstoneChannel, @UseOnly(value=LogicalSide.SERVER) ItemStack filterInsert, @UseOnly(value=LogicalSide.SERVER) ItemStack filterExtract, @UseOnly(value=LogicalSide.SERVER) ItemStack upgradeExtract) implements ConnectionState
{
    public static DynamicConnectionState defaultConnection(Level level, BlockPos pos, Direction direction, ConduitType<?> type) {
        ConduitType.ConduitConnectionData defaultConnection = type.getDefaultConnection(level, pos, direction);
        return new DynamicConnectionState(defaultConnection.isInsert(), ColorControl.GREEN, defaultConnection.isExtract(), ColorControl.GREEN, defaultConnection.control(), ColorControl.RED, ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_);
    }

    @Override
    public boolean isConnection() {
        return this.isInsert || this.isExtract;
    }

    public ItemStack getItem(SlotType slotType) {
        if (slotType == SlotType.FILTER_EXTRACT) {
            return this.filterExtract;
        }
        if (slotType == SlotType.FILTER_INSERT) {
            return this.filterInsert;
        }
        return this.upgradeExtract;
    }

    public DynamicConnectionState withoutConnection() {
        return new DynamicConnectionState(false, this.insertChannel, false, this.extractChannel, this.control, this.redstoneChannel, this.filterInsert, this.filterExtract, this.upgradeExtract);
    }

    public DynamicConnectionState withItems(DynamicConnectionState other) {
        return new DynamicConnectionState(this.isInsert, this.insertChannel, this.isExtract, this.extractChannel, this.control, this.redstoneChannel, other.filterInsert, other.filterExtract, other.upgradeExtract);
    }

    public DynamicConnectionState withItem(SlotType type, ItemStack stack) {
        HashMap<SlotType, ItemStack> items = new HashMap<SlotType, ItemStack>();
        for (SlotType type1 : SlotType.values()) {
            items.put(type1, type1 == type ? stack : this.getItem(type1));
        }
        return new DynamicConnectionState(this.isInsert, this.insertChannel, this.isExtract, this.extractChannel, this.control, this.redstoneChannel, (ItemStack)items.get((Object)SlotType.FILTER_INSERT), (ItemStack)items.get((Object)SlotType.FILTER_EXTRACT), (ItemStack)items.get((Object)SlotType.UPGRADE_EXTRACT));
    }

    public DynamicConnectionState withEnabled(boolean forExtract, boolean value) {
        return new DynamicConnectionState(!forExtract ? value : this.isInsert, this.insertChannel, forExtract ? value : this.isExtract, this.extractChannel, this.control, this.redstoneChannel, this.filterInsert, this.filterExtract, this.upgradeExtract);
    }

    public DynamicConnectionState withColor(boolean forExtract, ColorControl value) {
        return new DynamicConnectionState(this.isInsert, !forExtract ? value : this.insertChannel, this.isExtract, forExtract ? value : this.extractChannel, this.control, this.redstoneChannel, this.filterInsert, this.filterExtract, this.upgradeExtract);
    }

    public DynamicConnectionState withRedstoneMode(RedstoneControl value) {
        return new DynamicConnectionState(this.isInsert, this.insertChannel, this.isExtract, this.extractChannel, value, this.redstoneChannel, this.filterInsert, this.filterExtract, this.upgradeExtract);
    }

    public DynamicConnectionState withRedstoneChannel(ColorControl value) {
        return new DynamicConnectionState(this.isInsert, this.insertChannel, this.isExtract, this.extractChannel, this.control, value, this.filterInsert, this.filterExtract, this.upgradeExtract);
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isInsert);
        buf.m_130068_((Enum)this.insertChannel);
        buf.writeBoolean(this.isExtract);
        buf.m_130068_((Enum)this.extractChannel);
        buf.m_130068_((Enum)this.control);
        buf.m_130068_((Enum)this.redstoneChannel);
        buf.writeItemStack(this.filterInsert, false);
        buf.writeItemStack(this.filterExtract, false);
        buf.writeItemStack(this.upgradeExtract, false);
    }

    public static DynamicConnectionState fromNetwork(FriendlyByteBuf buf) {
        boolean isInsert = buf.readBoolean();
        ColorControl insert = (ColorControl)buf.m_130066_(ColorControl.class);
        boolean isExtract = buf.readBoolean();
        ColorControl extract = (ColorControl)buf.m_130066_(ColorControl.class);
        RedstoneControl control = (RedstoneControl)buf.m_130066_(RedstoneControl.class);
        ColorControl redstoneChannel = (ColorControl)buf.m_130066_(ColorControl.class);
        ItemStack filterInsert = buf.m_130267_();
        ItemStack filterExtract = buf.m_130267_();
        ItemStack upgradeInsert = buf.m_130267_();
        return new DynamicConnectionState(isInsert, insert, isExtract, extract, control, redstoneChannel, filterInsert, filterExtract, upgradeInsert);
    }
}

