/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.joefoxe.hexerei.client.renderer.entity.custom.ModBoatEntity;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class ModBoatRenderer
extends EntityRenderer<ModBoatEntity> {
    private final Map<ModBoatEntity.Type, Pair<ResourceLocation, BoatModel>> boatResources;

    public ModBoatRenderer(EntityRendererProvider.Context p_234563_) {
        super(p_234563_);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(ModBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(p_173938_ -> p_173938_, p_234575_ -> Pair.of((Object)new ResourceLocation("hexerei", ModBoatRenderer.getTextureLocation(p_234575_)), (Object)this.createBoatModel(p_234563_, (ModBoatEntity.Type)((Object)p_234575_)))));
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context p_234569_, ModBoatEntity.Type p_234570_) {
        ModelLayerLocation modellayerlocation = new ModelLayerLocation(new ResourceLocation("hexerei", "boat/" + p_234570_.getName()), "main");
        return new BoatModel(p_234569_.m_174023_(modellayerlocation));
    }

    public void render(ModBoatEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        float f2;
        pMatrixStack.m_85836_();
        pMatrixStack.m_85837_(0.0, 0.375, 0.0);
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - pEntityYaw));
        float f = (float)pEntity.m_38385_() - pPartialTicks;
        float f1 = pEntity.m_38384_() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)pEntity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = pEntity.m_38352_(pPartialTicks)), (float)0.0f)) {
            pMatrixStack.m_252781_(new Quaternionf().setAngleAxis(pEntity.m_38352_(pPartialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, BoatModel> pair = this.getModelWithLocation(pEntity);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        BoatModel boatmodel = (BoatModel)pair.getSecond();
        pMatrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        boatmodel.m_6973_((Boat)pEntity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(boatmodel.m_103119_(resourcelocation));
        boatmodel.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!pEntity.m_5842_()) {
            VertexConsumer vertexconsumer1 = pBuffer.m_6299_(RenderType.m_110478_());
            boatmodel.m_102282_().m_104301_(pMatrixStack, vertexconsumer1, pPackedLight, OverlayTexture.f_118083_);
        }
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(ModBoatEntity entity) {
        return new ResourceLocation("hexerei", ModBoatRenderer.getTextureLocation(entity.getModBoatType()));
    }

    private static String getTextureLocation(ModBoatEntity.Type p_234566_) {
        return "textures/entity/boat/" + p_234566_.getName() + ".png";
    }

    public Pair<ResourceLocation, BoatModel> getModelWithLocation(ModBoatEntity boat) {
        return this.boatResources.get((Object)boat.getModBoatType());
    }
}

