/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.light;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.item.custom.BroomBrushItem;
import net.joefoxe.hexerei.item.custom.KeychainItem;
import net.joefoxe.hexerei.light.DynamicLightUtil;
import net.joefoxe.hexerei.light.LambHexereiDynamicLight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightManager {
    private static final Set<LambHexereiDynamicLight> dynamicLightSources = new HashSet<LambHexereiDynamicLight>();
    private static final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    public static long lastUpdate = System.currentTimeMillis();
    public static int lastUpdateCount = 0;
    private static final Map<EntityType<?>, List<Function<?, Integer>>> LIGHT_REGISTRY = new HashMap();
    private static final double MAX_RADIUS = 7.75;
    private static final double MAX_RADIUS_SQUARED = 60.0625;

    public static void init() {
        LightManager.register(EntityType.f_20450_, p -> p.m_31980_().getLightEmission((BlockGetter)p.m_9236_(), p.m_20183_()));
        LightManager.register(EntityType.f_20566_, enderMan -> {
            if (enderMan.m_32530_() != null) {
                return DynamicLightUtil.fromItemLike((ItemLike)enderMan.m_32530_().m_60734_());
            }
            return 0;
        });
        LightManager.register(EntityType.f_20461_, p -> DynamicLightUtil.fromItemLike((ItemLike)p.m_32055_().m_41720_()));
        LightManager.register((EntityType)ModEntityTypes.BROOM.get(), LightManager::broomLightCheck);
        LightManager.register(EntityType.f_20532_, p -> {
            Entity patt2441$temp = p.m_20202_();
            if (patt2441$temp instanceof BroomEntity) {
                BroomEntity broom = (BroomEntity)patt2441$temp;
                return LightManager.broomLightCheck(broom);
            }
            return 0;
        });
        LightManager.register(EntityType.f_20462_, p -> DynamicLightUtil.fromItemLike((ItemLike)p.m_31822_().m_41720_()));
        LightManager.register(EntityType.f_147033_, p -> Math.max(14, DynamicLightUtil.fromItemLike((ItemLike)p.m_31822_().m_41720_())));
        LightManager.register(EntityType.f_147034_, p -> (int)Mth.m_144920_((float)0.0f, (float)12.0f, (float)(1.0f - (float)p.m_147128_() / 10.0f)));
    }

    private static int broomLightCheck(BroomEntity broom) {
        BroomBrushItem brushItem;
        Item item = broom.getModule(BroomEntity.BroomSlot.BRUSH).m_41720_();
        if (item instanceof BroomBrushItem && (brushItem = (BroomBrushItem)item).shouldGlow(broom.m_9236_(), broom.getModule(BroomEntity.BroomSlot.BRUSH))) {
            return 15;
        }
        item = broom.getModule(BroomEntity.BroomSlot.MISC).m_41720_();
        if (item instanceof KeychainItem) {
            KeychainItem keychainItem = (KeychainItem)item;
            NonNullList items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
            if (broom.getModule(BroomEntity.BroomSlot.MISC).m_41782_()) {
                ContainerHelper.m_18980_((CompoundTag)broom.getModule(BroomEntity.BroomSlot.MISC).m_41784_(), (NonNullList)items);
            }
            return DynamicLightUtil.fromItemLike((ItemLike)((ItemStack)items.get(0)).m_41720_());
        }
        return 0;
    }

    public static <T extends Entity> void register(EntityType<T> type, Function<T, Integer> luminanceFunction) {
        if (!LIGHT_REGISTRY.containsKey(type)) {
            LIGHT_REGISTRY.put(type, new ArrayList());
        }
        LIGHT_REGISTRY.get(type).add(luminanceFunction);
    }

    public static <T extends Entity> Map<EntityType<?>, List<Function<?, Integer>>> getLightRegistry() {
        return LIGHT_REGISTRY;
    }

    public static <T extends Entity> int getValue(T entity) {
        int val = 0;
        if (!LIGHT_REGISTRY.containsKey(entity.m_6095_())) {
            return val;
        }
        EntityType type = entity.m_6095_();
        for (Function<?, Integer> function : LIGHT_REGISTRY.get(type)) {
            Function<?, Integer> fun = function;
            Integer value = fun.apply(entity);
            if (value <= val) continue;
            val = value;
        }
        return val;
    }

    public static boolean containsEntity(EntityType<? extends Entity> type) {
        return LIGHT_REGISTRY.containsKey(type) || HexConfig.ENTITY_LIGHT_MAP.containsKey(ForgeRegistries.ENTITY_TYPES.getKey(type));
    }

    public static void addLightSource(LambHexereiDynamicLight lightSource) {
        if (!lightSource.getDynamicLightWorldH().m_5776_()) {
            return;
        }
        if (!LightManager.shouldUpdateDynamicLight()) {
            return;
        }
        if (LightManager.containsLightSource(lightSource)) {
            return;
        }
        lightSourcesLock.writeLock().lock();
        dynamicLightSources.add(lightSource);
        lightSourcesLock.writeLock().unlock();
    }

    public static boolean containsLightSource(@NotNull LambHexereiDynamicLight lightSource) {
        if (!lightSource.getDynamicLightWorldH().m_5776_()) {
            return false;
        }
        lightSourcesLock.readLock().lock();
        boolean result = dynamicLightSources.contains(lightSource);
        lightSourcesLock.readLock().unlock();
        return result;
    }

    public int getLightSourcesCount() {
        lightSourcesLock.readLock().lock();
        int result = dynamicLightSources.size();
        lightSourcesLock.readLock().unlock();
        return result;
    }

    public static void removeLightSource(LambHexereiDynamicLight lightSource) {
        lightSourcesLock.writeLock().lock();
        Iterator<LambHexereiDynamicLight> sourceIterator = dynamicLightSources.iterator();
        while (sourceIterator.hasNext()) {
            LambHexereiDynamicLight it = sourceIterator.next();
            if (!it.equals(lightSource)) continue;
            sourceIterator.remove();
            if (Minecraft.m_91087_().f_91073_ == null) break;
            lightSource.lambdynlights$scheduleTrackedChunksRebuildH(Minecraft.m_91087_().f_91060_);
            break;
        }
        lightSourcesLock.writeLock().unlock();
    }

    public static void clearLightSources() {
        lightSourcesLock.writeLock().lock();
        Iterator<LambHexereiDynamicLight> sourceIterator = dynamicLightSources.iterator();
        while (sourceIterator.hasNext()) {
            LambHexereiDynamicLight it = sourceIterator.next();
            sourceIterator.remove();
            if (Minecraft.m_91087_().f_91060_ == null) continue;
            if (it.getLuminanceH() > 0) {
                it.resetDynamicLightH();
            }
            it.lambdynlights$scheduleTrackedChunksRebuildH(Minecraft.m_91087_().f_91060_);
        }
        lightSourcesLock.writeLock().unlock();
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, @NotNull BlockPos chunkPos) {
        LightManager.scheduleChunkRebuild(renderer, chunkPos.m_123341_(), chunkPos.m_123342_(), chunkPos.m_123343_());
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, long chunkPos) {
        LightManager.scheduleChunkRebuild(renderer, BlockPos.m_121983_((long)chunkPos), BlockPos.m_122008_((long)chunkPos), BlockPos.m_122015_((long)chunkPos));
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, int x, int y, int z) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            renderer.m_109770_(x, y, z);
        }
    }

    public static void updateAll(LevelRenderer renderer) {
        long now;
        lastUpdate = now = System.currentTimeMillis();
        lastUpdateCount = 0;
        lightSourcesLock.readLock().lock();
        for (LambHexereiDynamicLight lightSource : dynamicLightSources) {
            if (!lightSource.lambdynlights$updateDynamicLightH(renderer)) continue;
            ++lastUpdateCount;
        }
        lightSourcesLock.readLock().unlock();
    }

    public static void updateTrackedChunks(@NotNull BlockPos chunkPos, @Nullable LongOpenHashSet old, @Nullable LongOpenHashSet newPos) {
        if (old != null || newPos != null) {
            long pos = chunkPos.m_121878_();
            if (old != null) {
                old.remove(pos);
            }
            if (newPos != null) {
                newPos.add(pos);
            }
        }
    }

    public static int getLightmapWithDynamicLight(@NotNull BlockPos pos, int lightmap) {
        return LightManager.getLightmapWithDynamicLight(LightManager.getDynamicLightLevelWorld(pos), lightmap);
    }

    public static int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = LightManager.getBlockLightNoPatch(lightmap))) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public static int getBlockLightNoPatch(int light) {
        return light >> 4 & 0xFFFF;
    }

    public static double getDynamicLightLevel(@NotNull BlockPos pos) {
        double result = 0.0;
        lightSourcesLock.readLock().lock();
        for (LambHexereiDynamicLight lightSource : dynamicLightSources) {
            result = LightManager.maxDynamicLightLevel(pos, lightSource, result);
        }
        lightSourcesLock.readLock().unlock();
        return Mth.m_14008_((double)result, (double)0.0, (double)15.0);
    }

    public static double getDynamicLightLevelWorld(@NotNull BlockPos pos) {
        double result = 0.0;
        lightSourcesLock.readLock().lock();
        for (LambHexereiDynamicLight lightSource : dynamicLightSources) {
            result = LightManager.maxDynamicLightLevel(pos, lightSource, result);
        }
        lightSourcesLock.readLock().unlock();
        return Mth.m_14008_((double)result, (double)0.0, (double)15.0);
    }

    public static double maxDynamicLightLevel(@NotNull BlockPos pos, @NotNull LambHexereiDynamicLight lightSource, double currentLightLevel) {
        double multiplier;
        double lightLevel;
        double dz;
        double dy;
        double dx;
        double distanceSquared;
        int luminance = lightSource.getLuminanceH();
        if (luminance > 0 && (distanceSquared = (dx = (double)pos.m_123341_() - lightSource.getDynamicLightXH() + 0.5) * dx + (dy = (double)pos.m_123342_() - lightSource.getDynamicLightYH() + 0.5) * dy + (dz = (double)pos.m_123343_() - lightSource.getDynamicLightZH() + 0.5) * dz) <= 60.0625 && (lightLevel = (multiplier = 1.0 - Math.sqrt(distanceSquared) / 7.75) * (double)luminance) > currentLightLevel) {
            return lightLevel;
        }
        return currentLightLevel;
    }

    public static void updateLightTracking(@NotNull LambHexereiDynamicLight lightSource) {
        boolean enabled = lightSource.isDynamicLightEnabledH();
        int luminance = lightSource.getLuminanceH();
        if (!enabled && luminance > 0) {
            lightSource.setHexereiDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.setHexereiDynamicLightEnabled(false);
        }
    }

    public static boolean shouldUpdateDynamicLight() {
        return (Boolean)HexConfig.DYNAMIC_LIGHT_TOGGLE.get();
    }

    public static void toggleLightsAndConfig(boolean enabled) {
        if (ModList.get().isLoaded("ars_nouveau")) {
            enabled = false;
        }
        HexConfig.DYNAMIC_LIGHT_TOGGLE.set((Object)enabled);
        HexConfig.DYNAMIC_LIGHT_TOGGLE.save();
        if (!enabled) {
            LightManager.clearLightSources();
        }
    }
}

