/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.api.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.data.IntCodec;
import top.theillusivec4.champions.common.config.ConfigEnums;
import top.theillusivec4.champions.common.loot.AffixesPredicate;
import top.theillusivec4.champions.common.rank.RankManager;

public record ChampionModifierCondition(Optional<Set<ResourceLocation>> mobList, Optional<MinMaxBounds.Ints> tier, Optional<AffixesPredicate> affixes, ConfigEnums.Permission permission) {
    public static final MapCodec<ChampionModifierCondition> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ChampionModifierCondition.setOf(ResourceLocation.f_135803_).optionalFieldOf("entity").forGetter(ChampionModifierCondition::mobList), (App)IntCodec.codec().optionalFieldOf("tier").forGetter(ChampionModifierCondition::tier), (App)AffixesPredicate.codec().optionalFieldOf("affixes").forGetter(ChampionModifierCondition::affixes), (App)StringRepresentable.m_216439_(ConfigEnums.Permission::values).fieldOf("permission").forGetter(ChampionModifierCondition::permission)).apply((Applicative)instance, ChampionModifierCondition::new));

    public static <T> Codec<Set<T>> setOf(Codec<T> codec) {
        return Codec.list(codec).xmap(ImmutableSet::copyOf, ImmutableList::copyOf);
    }

    public boolean test(@NotNull IChampion champion) {
        EntityType entityType = champion.getLivingEntity().m_6095_();
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType);
        List<IAffix> championAffixes = champion.getServer().getAffixes();
        int championTier = champion.getServer().getRank().orElse(RankManager.getEmptyRank()).getTier();
        boolean entityMatches = this.mobList.map(mobs -> mobs.contains(entityId)).map(matches -> this.permission == ConfigEnums.Permission.WHITELIST == matches).orElse(true);
        return entityMatches && this.tier.map(t -> t.m_55390_(championTier)).orElse(true) != false && this.affixes.map(affixesPredicate -> affixesPredicate.matches(championAffixes)).orElse(true) != false;
    }
}

