/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ClientChampionsConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    private static final String CONFIG_PREFIX = "gui.champions.config.";
    public static int hudXOffset;
    public static int hudYOffset;
    public static int hudRange;
    public static int lineCount;
    public static boolean enableWailaIntegration;
    public static boolean enablePlaguedParticle;
    public static int jadeStarSpacing;
    public static int jadeStarBottomPadding;

    public static void bake() {
        hudXOffset = (Integer)ClientChampionsConfig.CLIENT.hudXOffset.get();
        hudYOffset = (Integer)ClientChampionsConfig.CLIENT.hudYOffset.get();
        hudRange = (Integer)ClientChampionsConfig.CLIENT.hudRange.get();
        enablePlaguedParticle = (Boolean)ClientChampionsConfig.CLIENT.enablePlaguedParticle.get();
        jadeStarSpacing = (Integer)ClientChampionsConfig.CLIENT.jadeStarSpacing.get();
        jadeStarBottomPadding = (Integer)ClientChampionsConfig.CLIENT.jadeStarBottomPadding.get();
        enableWailaIntegration = (Boolean)ClientChampionsConfig.CLIENT.enableWailaIntegration.get();
        lineCount = (Integer)ClientChampionsConfig.CLIENT.lineCount.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.IntValue hudXOffset;
        public final ForgeConfigSpec.IntValue hudYOffset;
        public final ForgeConfigSpec.IntValue hudRange;
        public final ForgeConfigSpec.BooleanValue enableWailaIntegration;
        public final ForgeConfigSpec.BooleanValue enablePlaguedParticle;
        public final ForgeConfigSpec.IntValue lineCount;
        public final ForgeConfigSpec.IntValue jadeStarSpacing;
        public final ForgeConfigSpec.IntValue jadeStarBottomPadding;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("hud");
            this.hudXOffset = builder.comment("The x-offset for the champion HUD").translation("gui.champions.config.hudXOffset").defineInRange("hudXOffset", 0, -1000, 1000);
            this.hudYOffset = builder.comment("The y-offset for the champion HUD").translation("gui.champions.config.hudYOffset").defineInRange("hudYOffset", 0, -1000, 1000);
            this.hudRange = builder.comment("The distance, in blocks, from which the champion HUD can be seen").translation("gui.champions.config.hudRange").defineInRange("hudRange", 50, 0, 1000);
            this.enableWailaIntegration = builder.comment("Set to true to move the WAILA overlay underneath the champion HUD").translation("gui.champions.config.enableWailaIntegration").define("enableWailaIntegration", true);
            this.enablePlaguedParticle = builder.comment("Set false to close the plagued affix particle").translation("gui.champions.config.enablePlaguedParticle").define("enablePlaguedParticle", true);
            this.lineCount = builder.comment("The affix line count of the jade compact").defineInRange("lineCount", 5, 1, 20);
            this.jadeStarSpacing = builder.comment("The Jade Star spacing, when rendering star.").defineInRange("jadeStarSpacing", 2, 0, 25);
            this.jadeStarBottomPadding = builder.comment("The Jade Star bottom padding, when rendering star.").defineInRange("jadeStarBottomPadding", 3, 0, 100);
            builder.pop();
        }
    }
}

