/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.integration.jade;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ui.TextElement;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.client.integration.jade.StarElement;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.util.ChampionHelper;
import top.theillusivec4.champions.common.util.Utils;

public enum ChampionComponentProvider implements IEntityComponentProvider
{
    INSTANCE;


    private static Component getChampionName(Tuple<Integer, String> rank, IChampion champion) {
        return Component.m_237115_((String)("rank.champions.title." + rank.m_14418_())).m_130946_(" " + champion.getLivingEntity().m_7755_().getString()).m_130948_(Style.f_131099_.m_178520_(Rank.getColor((String)rank.m_14419_())));
    }

    private static Component getChampionDescription(IAffix affix) {
        return Component.m_237115_((String)affix.toLanguageKey());
    }

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        ChampionCapability.getCapability(entityAccessor.getEntity()).ifPresent(champion -> {
            IChampion.Client clientChampion = champion.getClient();
            if (ChampionHelper.isValidChampion(clientChampion)) {
                champion.getClient().getRank().ifPresent(rank -> {
                    iTooltip.get(0, IElement.Align.LEFT).set(0, new TextElement(ChampionComponentProvider.getChampionName((Tuple<Integer, String>)rank, champion)));
                    StarElement starElement = StarElement.of((Integer)rank.m_14418_(), (String)rank.m_14419_(), ClientChampionsConfig.jadeStarSpacing);
                    iTooltip.add(1, (IElement)starElement);
                });
                List<IAffix> affixes = champion.getClient().getAffixes();
                ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
                StringBuilder line = new StringBuilder();
                for (int i = 0; i < affixes.size(); ++i) {
                    line.append(ChampionComponentProvider.getChampionDescription(affixes.get(i)).getString());
                    if ((i + 1) % ClientChampionsConfig.lineCount == 0 || i == affixes.size() - 1) {
                        components.add(Component.m_237113_((String)line.toString()));
                        line.setLength(0);
                        continue;
                    }
                    line.append(" ");
                }
                iTooltip.addAll(components);
            }
        });
    }

    public ResourceLocation getUid() {
        return Utils.getLocation("enable_affix_compact");
    }
}

