/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.registry.ModDamageTypes;

public class ReflectiveAffix
extends BasicAffix {
    @SubscribeEvent
    public void onDamageEvent(LivingDamageEvent evt) {
        if (!ChampionsConfig.reflectiveLethal && evt.getSource().m_276093_(ModDamageTypes.REFLECTION_DAMAGE)) {
            LivingEntity living = evt.getEntity();
            float currentDamage = evt.getAmount();
            if (currentDamage >= living.m_21223_()) {
                evt.setAmount(living.m_21223_() - 1.0f);
            }
        }
    }

    @Override
    public float onDamage(IChampion champion, DamageSource source, float amount, float newAmount) {
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity sourceEntity = (LivingEntity)entity;
            if (source.m_276093_(ModDamageTypes.REFLECTION_DAMAGE) || source.m_276093_(DamageTypes.f_268440_)) {
                return newAmount;
            }
            DamageSource newSource = ModDamageTypes.of(ModDamageTypes.REFLECTION_DAMAGE, (Entity)champion.getLivingEntity());
            if (source.m_7639_() != null) {
                newSource = ModDamageTypes.of(ModDamageTypes.REFLECTION_DAMAGE, source.m_7640_(), (Entity)champion.getLivingEntity());
            }
            float min = (float)ChampionsConfig.reflectiveMinPercent;
            float damage = (float)Math.min((double)amount * ((double)sourceEntity.m_217043_().m_188501_() * (ChampionsConfig.reflectiveMaxPercent - (double)min) + (double)min), (double)ChampionsConfig.reflectiveMax);
            sourceEntity.m_6469_(newSource, damage);
        }
        return newAmount;
    }
}

