/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.AffixData;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;

public class ShieldingAffix
extends BasicAffix {
    @Override
    public void onClientUpdate(IChampion champion) {
        LivingEntity livingEntity = champion.getLivingEntity();
        AffixData.BooleanData shielding = AffixData.getData(champion, this.toString(), AffixData.BooleanData.class);
        RandomSource random = livingEntity.m_217043_();
        if (shielding.mode) {
            livingEntity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, livingEntity.m_20182_().f_82479_ + ((double)random.m_188501_() - 0.5) * (double)livingEntity.m_20205_(), livingEntity.m_20182_().f_82480_ + (double)(random.m_188501_() * livingEntity.m_20206_()), livingEntity.m_20182_().f_82481_ + ((double)random.m_188501_() - 0.5) * (double)livingEntity.m_20205_(), 1.0, 1.0, 1.0);
        }
    }

    @Override
    public void onServerUpdate(IChampion champion) {
        LivingEntity livingEntity = champion.getLivingEntity();
        if (livingEntity.f_19797_ % 40 == 0 && livingEntity.m_217043_().m_188500_() < ChampionsConfig.shieldingChance) {
            AffixData.BooleanData shielding = AffixData.getData(champion, this.toString(), AffixData.BooleanData.class);
            shielding.mode = !shielding.mode;
            shielding.saveData();
            this.sync(champion);
        }
    }

    @Override
    public void readSyncTag(IChampion champion, CompoundTag tag) {
        AffixData.BooleanData shielding = AffixData.getData(champion, this.toString(), AffixData.BooleanData.class);
        shielding.readFromNBT(tag);
        shielding.saveData();
    }

    @Override
    public CompoundTag writeSyncTag(IChampion champion) {
        return AffixData.getData(champion, this.toString(), AffixData.BooleanData.class).writeToNBT();
    }

    @Override
    public boolean onAttacked(IChampion champion, DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268724_)) {
            return true;
        }
        AffixData.BooleanData shielding = AffixData.getData(champion, this.toString(), AffixData.BooleanData.class);
        if (shielding.mode) {
            champion.getLivingEntity().m_5496_(SoundEvents.f_12315_, 1.0f, 1.0f);
            return false;
        }
        return true;
    }
}

