/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.integration.gateways_to_eternity;

import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.event.GateEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.champions.api.AffixRegistry;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.integration.gateways_to_eternity.Gateways;
import top.theillusivec4.champions.common.integration.gateways_to_eternity.GatewaysSetting;
import top.theillusivec4.champions.common.integration.gateways_to_eternity.GatewaysSettingLoader;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.util.ChampionBuilder;
import top.theillusivec4.champions.common.util.ChampionHelper;

public class GatewaysToEternityCompat {
    private final GatewaysSettingLoader settings = new GatewaysSettingLoader();

    @SubscribeEvent
    public void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this.settings);
    }

    @SubscribeEvent
    public void onWaveEntitySpawned(GateEvent.WaveEntitySpawned event) {
        LivingEntity waveSpawnedEntity = event.getWaveEntity();
        ResourceLocation waveSpawnedEntityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)waveSpawnedEntity.m_6095_());
        GatewayEntity gatewayEntity = event.getEntity();
        int currentWave = gatewayEntity.getWave();
        Gateways eventGateWayEntityType = GatewaysSetting.byEntityType(gatewayEntity);
        this.settings.getLoadedData().values().forEach(gatewaysSetting -> {
            Gateways gatewayTypeSetting = gatewaysSetting.gatewayType();
            List<Object> entityList = gatewaysSetting.entityBlackList().isPresent() ? gatewaysSetting.entityBlackList().get() : new ArrayList();
            MinMaxBounds.Ints waveRange = gatewaysSetting.waveRange();
            if (!gatewaysSetting.enable().orElse(false).booleanValue() || eventGateWayEntityType != gatewayTypeSetting || !waveRange.m_55390_(currentWave) || entityList.contains(waveSpawnedEntityId)) {
                return;
            }
            ChampionCapability.getCapability(waveSpawnedEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (ChampionHelper.isValidChampion(serverChampion)) {
                    ChampionBuilder.resetAndUpdate(champion);
                }
                ArrayList<IAffix> affixes = new ArrayList<IAffix>();
                MinMaxBounds.Ints tierRange = gatewaysSetting.tier();
                int minTier = tierRange.m_55305_() != null ? (Integer)tierRange.m_55305_() : 0;
                int maxTier = tierRange.m_55326_() != null ? ((Integer)tierRange.m_55326_()).intValue() : RankManager.getHighestRank().getTier();
                maxTier = Math.max(minTier, maxTier);
                int rangedRandomTier = champion.getLivingEntity().m_217043_().m_216332_(minTier, maxTier);
                gatewaysSetting.affixes().forEach(affixId -> affixes.add((IAffix)AffixRegistry.getRegistry().getValue(affixId)));
                ChampionBuilder.spawnPreset(champion, rangedRandomTier, affixes);
            });
        });
    }
}

