/*
 * Decompiled with CFR 0.152.
 */
package portb.biggerstacks.event;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import portb.biggerstacks.Constants;
import portb.biggerstacks.config.StackSizeRules;
import portb.biggerstacks.util.ConfigCommand;

@Mod.EventBusSubscriber(modid="biggerstacks")
public class CommonForgeEvents {
    private static final Style SETUP_COMMAND_SHORTCUT = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/biggerstacks quicksetup")).m_131140_(ChatFormatting.BLUE).m_131162_(Boolean.valueOf(true));
    private static final Style WIKI_LINK = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://codeberg.org/PORTB/BiggerStacks/wiki")).m_131140_(ChatFormatting.BLUE).m_131162_(Boolean.valueOf(true));
    private static final Component BULLET_POINT = Component.m_237113_((String)"\n> ").m_130940_(ChatFormatting.WHITE);

    @SubscribeEvent
    public static void warnIfNoRulesetExists(PlayerEvent.PlayerLoggedInEvent event) {
        if (!Files.exists(Constants.RULESET_FILE, new LinkOption[0]) && StackSizeRules.maxRegisteredItemStackSize == 64) {
            if (FMLEnvironment.dist.isDedicatedServer() && !event.getEntity().m_20310_(4)) {
                return;
            }
            event.getEntity().m_5661_((Component)Component.m_237113_((String)"Biggerstacks is installed, but you have not configured it and there are no other mods installed that use it.").m_7220_(BULLET_POINT).m_130946_("Run ").m_7220_((Component)Component.m_237113_((String)"/biggerstacks quicksetup").m_130948_(SETUP_COMMAND_SHORTCUT)).m_130946_(" and the mod will generate a simple ruleset for you").m_7220_(BULLET_POINT).m_130946_("Or click ").m_7220_((Component)Component.m_237113_((String)"here").m_130948_(WIKI_LINK)).m_130946_(" to see how to create a custom ruleset").m_130940_(ChatFormatting.GOLD), false);
        }
    }

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        ConfigCommand.register(event);
    }
}

