/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.listeners.bossbar;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.level.Level;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.event.task.GenerationTaskUpdateEvent;
import org.popcraft.chunky.platform.ForgeWorld;
import org.popcraft.chunky.platform.World;

public class BossBarTaskUpdateListener
implements Consumer<GenerationTaskUpdateEvent> {
    private final Map<ResourceLocation, ServerBossEvent> bossBars;

    public BossBarTaskUpdateListener(Map<ResourceLocation, ServerBossEvent> bossBars) {
        this.bossBars = bossBars;
    }

    @Override
    public void accept(GenerationTaskUpdateEvent event) {
        GenerationTask task = event.generationTask();
        Chunky chunky = task.getChunky();
        World world = task.getSelection().world();
        ResourceLocation worldIdentifier = ResourceLocation.m_135820_((String)world.getKey());
        if (worldIdentifier == null || !(world instanceof ForgeWorld)) {
            return;
        }
        ForgeWorld forgeWorld = (ForgeWorld)world;
        ServerBossEvent bossBar = this.bossBars.computeIfAbsent(worldIdentifier, x -> this.createNewBossBar(worldIdentifier));
        boolean silent = chunky.getConfig().isSilent();
        if (silent == bossBar.m_8323_()) {
            bossBar.m_8321_(!silent);
        }
        MinecraftServer server = forgeWorld.getWorld().m_7654_();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            if (player.m_20310_(2)) {
                bossBar.m_6543_(player);
                continue;
            }
            bossBar.m_6539_(player);
        }
        GenerationTask.Progress progress = task.getProgress();
        bossBar.m_6456_(Component.m_130674_((String)String.format("%s | %s%% | %s:%s:%s", worldIdentifier, String.format("%.2f", Float.valueOf(progress.getPercentComplete())), String.format("%01d", progress.getHours()), String.format("%02d", progress.getMinutes()), String.format("%02d", progress.getSeconds()))));
        bossBar.m_142711_(task.getProgress().getPercentComplete() / 100.0f);
        if (progress.isComplete()) {
            bossBar.m_7706_();
            this.bossBars.remove(worldIdentifier);
        }
    }

    private ServerBossEvent createNewBossBar(ResourceLocation worldIdentifier) {
        ServerBossEvent bossBar = new ServerBossEvent(Component.m_130674_((String)worldIdentifier.toString()), BossBarTaskUpdateListener.bossBarColor(worldIdentifier), BossEvent.BossBarOverlay.PROGRESS);
        bossBar.m_7003_(false);
        bossBar.m_7005_(false);
        bossBar.m_7006_(false);
        return bossBar;
    }

    private static BossEvent.BossBarColor bossBarColor(ResourceLocation worldIdentifier) {
        BossEvent.BossBarColor bossBarColor = Level.f_46428_.m_135782_().equals((Object)worldIdentifier) ? BossEvent.BossBarColor.GREEN : (Level.f_46429_.m_135782_().equals((Object)worldIdentifier) ? BossEvent.BossBarColor.RED : (Level.f_46430_.m_135782_().equals((Object)worldIdentifier) ? BossEvent.BossBarColor.PURPLE : BossEvent.BossBarColor.BLUE));
        return bossBarColor;
    }
}

