/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.util;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TaskScheduler {
    private final ExecutorService executor;
    private final Set<Future<?>> futures = ConcurrentHashMap.newKeySet();

    public TaskScheduler() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(3, Integer.MAX_VALUE, 5L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>());
        threadPoolExecutor.setThreadFactory(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        });
        threadPoolExecutor.prestartAllCoreThreads();
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        this.executor = threadPoolExecutor;
    }

    public void runTask(Runnable runnable) {
        this.futures.add(this.executor.submit(runnable));
        this.futures.removeIf(Future::isDone);
    }

    public void cancelTasks() {
        for (Future<?> future : this.futures) {
            future.cancel(true);
        }
        this.futures.clear();
    }
}

