/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.animate.server.ai.animation;

import com.eeeab.animate.server.ai.AnimationSimpleAI;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.eeeabsmobs.sever.entity.EEEABMobLibrary;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class AnimationRepel<T extends EEEABMobLibrary>
extends AnimationSimpleAI<T> {
    private final int attackFrame;
    private final boolean pureShotEffect;
    private final float range;
    private final float applyKnockBackMultiplier;
    private final float damageMultiplier;

    public AnimationRepel(T entity, Supplier<Animation> animationSupplier, float range, int attackFrame, float applyKnockBackMultiplier, float damageMultiplier, boolean pureShotEffect) {
        super(entity, animationSupplier);
        this.range = range;
        this.attackFrame = attackFrame;
        this.applyKnockBackMultiplier = applyKnockBackMultiplier;
        this.damageMultiplier = damageMultiplier;
        this.pureShotEffect = pureShotEffect;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.entity.getAnimationTick() == this.attackFrame) {
            List<LivingEntity> hitEntities = this.entity.getNearByLivingEntities(this.range, this.range * 2.0f, this.range, this.range);
            for (LivingEntity hit : hitEntities) {
                if (this.preHit(hit)) continue;
                this.entity.doHurtTarget((Entity)hit, this.damageMultiplier, this.applyKnockBackMultiplier);
                if (!this.pureShotEffect || hit.m_20147_()) continue;
                if (hit instanceof Player) {
                    Player player = (Player)hit;
                    if (player.m_150110_().f_35934_) continue;
                }
                double angle = this.entity.getAngleBetweenEntities((Entity)this.entity, (Entity)hit);
                double x = (double)this.applyKnockBackMultiplier * Math.cos(Math.toRadians(angle - 90.0));
                double z = (double)this.applyKnockBackMultiplier * Math.sin(Math.toRadians(angle - 90.0));
                hit.m_20334_(x, 0.35, z);
                if (hit instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)hit;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)hit));
                }
                this.onHit(hit);
            }
        }
    }

    protected void onHit(LivingEntity entity) {
    }

    protected boolean preHit(LivingEntity entity) {
        return false;
    }
}

