/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.guling;

import com.eeeab.animate.server.ai.AnimationAI;
import com.eeeab.animate.server.ai.animation.AnimationActivate;
import com.eeeab.animate.server.ai.animation.AnimationDeactivate;
import com.eeeab.animate.server.ai.animation.AnimationDie;
import com.eeeab.animate.server.ai.animation.AnimationHurt;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.handler.EMAnimationHandler;
import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleBase;
import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleData;
import com.eeeab.eeeabsmobs.client.particle.util.ParticleComponent;
import com.eeeab.eeeabsmobs.client.particle.util.anim.AnimData;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.CrackinessEntity;
import com.eeeab.eeeabsmobs.sever.entity.EEEABMobLibrary;
import com.eeeab.eeeabsmobs.sever.entity.GlowEntity;
import com.eeeab.eeeabsmobs.sever.entity.IEntity;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityGuardianLaser;
import com.eeeab.eeeabsmobs.sever.entity.guling.EntityAbsGuling;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.eeeab.eeeabsmobs.sever.util.EMTagKey;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityGulingSentinel
extends EntityAbsGuling
implements IEntity,
GlowEntity,
CrackinessEntity<EntityGulingSentinel> {
    public final Animation dieAnimation = Animation.create(20);
    public final Animation hurtAnimation = Animation.create(3);
    public final Animation activeAnimation = Animation.create(20);
    public final Animation deactivateAnimation = Animation.create(20);
    public final Animation shootLaserAnimation = Animation.create(50);
    private final Animation[] animations = new Animation[]{this.dieAnimation, this.hurtAnimation, this.activeAnimation, this.deactivateAnimation, this.shootLaserAnimation};
    private int attackTick;
    private int deactivateTick;
    private static final EntityDimensions DEACTIVATE_SIZE = EntityDimensions.m_20395_((float)1.0f, (float)1.0f);
    private static final EntityDataAccessor<Boolean> DATA_ACTIVE = SynchedEntityData.m_135353_(EntityGulingSentinel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ALWAYS_ACTIVE = SynchedEntityData.m_135353_(EntityGulingSentinel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EntityGulingSentinel(EntityType<? extends EEEABMobLibrary> type, Level level) {
        super(type, level);
        this.active = false;
    }

    public float getStepHeight() {
        return 1.5f;
    }

    protected int m_7302_(int air) {
        return air;
    }

    @Override
    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.75f;
    }

    public void m_7601_(BlockState state, Vec3 motionMultiplier) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, motionMultiplier);
        }
    }

    protected BodyRotationControl m_7560_() {
        return new NoneRotationControl((Mob)this);
    }

    public boolean m_5829_() {
        return this.m_6084_() && !this.isActive();
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    protected AABB m_142242_() {
        return this.isActive() ? super.m_142242_() : DEACTIVATE_SIZE.m_20393_(this.m_20182_());
    }

    @Override
    protected EMConfigHandler.AttributeConfig getAttributeConfig() {
        return EMConfigHandler.COMMON.MOB.GULING.GULING_SENTINEL.combatConfig;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{EntityAbsGuling.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal(this, 0.6){

            public boolean m_8036_() {
                return super.m_8036_() && EntityGulingSentinel.this.isActive();
            }
        });
    }

    @Override
    protected void registerCustomGoals() {
        super.registerCustomGoals();
        this.f_21345_.m_25352_(1, new AnimationActivate<EntityGulingSentinel>(this, () -> this.activeAnimation));
        this.f_21345_.m_25352_(1, new AnimationDeactivate<EntityGulingSentinel>(this, () -> this.deactivateAnimation));
        this.f_21345_.m_25352_(1, new AnimationDie<EntityGulingSentinel>(this));
        this.f_21345_.m_25352_(1, new AnimationHurt<EntityGulingSentinel>(this, false));
        this.f_21345_.m_25352_(1, (Goal)new AnimationAI<EntityGulingSentinel>(this){

            @Override
            protected boolean test(Animation animation) {
                return animation == ((EntityGulingSentinel)this.entity).shootLaserAnimation;
            }

            public void m_8037_() {
                LivingEntity entityTarget = ((EntityGulingSentinel)this.entity).m_5448_();
                ((EntityGulingSentinel)this.entity).m_20334_(0.0, ((EntityGulingSentinel)this.entity).m_20096_() ? 0.0 : ((EntityGulingSentinel)this.entity).m_20184_().f_82480_, 0.0);
                int tick = ((EntityGulingSentinel)this.entity).getAnimationTick();
                if (entityTarget != null) {
                    if (tick < 40) {
                        ((EntityGulingSentinel)this.entity).m_21391_((Entity)entityTarget, 360.0f, 180.0f);
                        ((EntityGulingSentinel)this.entity).m_21563_().m_24960_((Entity)entityTarget, 360.0f, 180.0f);
                        ((EntityGulingSentinel)this.entity).m_146922_(((EntityGulingSentinel)this.entity).f_20883_);
                    } else {
                        ((EntityGulingSentinel)this.entity).m_146922_(((EntityGulingSentinel)this.entity).f_19859_);
                    }
                }
                if (tick == 5) {
                    double px = ((EntityGulingSentinel)this.entity).m_20185_();
                    double py = ((EntityGulingSentinel)this.entity).m_20186_() + 1.4;
                    double pz = ((EntityGulingSentinel)this.entity).m_20189_();
                    float yHeadRotAngle = (float)Math.toRadians(((EntityGulingSentinel)this.entity).f_20885_ + 90.0f);
                    float xHeadRotAngle = (float)Math.toRadians(-((EntityGulingSentinel)this.entity).m_146909_());
                    EntityGuardianLaser laser = new EntityGuardianLaser((EntityType<? extends EntityGuardianLaser>)((EntityType)EntityInit.GUARDIAN_LASER.get()), ((EntityGulingSentinel)this.entity).m_9236_(), (LivingEntity)this.entity, px, py, pz, yHeadRotAngle, xHeadRotAngle, 5);
                    ((EntityGulingSentinel)this.entity).m_9236_().m_7967_((Entity)laser);
                    ((EntityGulingSentinel)this.entity).m_9236_().m_7605_((Entity)this.entity, (byte)7);
                } else if (tick == 28) {
                    ((EntityGulingSentinel)this.entity).m_5496_((SoundEvent)SoundInit.GS_ELECTROMAGNETIC.get(), 0.5f, ((EntityGulingSentinel)this.entity).m_6100_());
                }
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new GSLookAtTargetGoal(this));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        EMAnimationHandler.INSTANCE.updateAnimations(this);
        if (!this.m_9236_().f_46443_) {
            if (this.m_5448_() != null && !this.m_5448_().m_6084_()) {
                this.m_6710_(null);
            }
            if (this.m_5448_() == null) {
                this.f_20885_ = this.m_146908_();
            }
            if (!this.m_21525_() && !this.isActive()) {
                if (((Boolean)EMConfigHandler.COMMON.MOB.GULING.GULING_SENTINEL.enableNonCombatHeal.get()).booleanValue()) {
                    this.m_5634_(0.5f);
                }
                this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
                this.f_20885_ = this.f_20883_ = this.m_146908_();
            }
            if (this.isAlwaysActive()) {
                this.setActive(true);
                this.active = true;
                this.deactivateTick = 0;
            } else if (!this.m_21525_() && this.isNoAnimation()) {
                if (!this.isActive() && this.m_5448_() != null && this.targetDistance <= 8.0f) {
                    this.m_216990_((SoundEvent)SoundInit.GSH_FRICTION.get());
                    this.playAnimation(this.activeAnimation);
                    this.setActive(true);
                }
                if (this.isActive() && this.m_5448_() == null && this.deactivateTick >= 200) {
                    this.m_216990_((SoundEvent)SoundInit.GSH_FRICTION.get());
                    this.playAnimation(this.deactivateAnimation);
                    this.setActive(false);
                }
            }
            if (!this.m_21525_() && this.isActive() && this.isNoAnimation() && this.m_5448_() != null) {
                if (this.targetDistance <= 8.0f) {
                    this.m_21573_().m_26573_();
                } else {
                    this.m_21573_().m_5624_((Entity)this.m_5448_(), 1.0);
                }
                if (this.attackTick <= 0) {
                    this.playAnimation(this.shootLaserAnimation);
                    this.attackTick = 100 + this.f_19796_.m_188503_(this.m_9236_().m_46791_() == Difficulty.HARD ? 20 : 100);
                    this.m_21573_().m_26573_();
                }
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.75, 1.0));
        }
        if (!this.m_9236_().f_46443_) {
            if (this.attackTick > 0) {
                --this.attackTick;
            }
            if (this.isActive() && !this.isAlwaysActive()) {
                if (this.m_5448_() == null) {
                    ++this.deactivateTick;
                } else if (this.deactivateTick > 0) {
                    this.deactivateTick = 0;
                }
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        if (this.m_9236_().f_46443_) {
            return false;
        }
        boolean projectileFlag = ModEntityUtils.isProjectileSource(source);
        if (!this.isActive() && projectileFlag) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            Item item;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.getAnimation() != this.getHurtAnimation() && !source.m_269533_(EMTagKey.GENERAL_UNRESISTANT_TO) && !source.m_276093_(DamageTypes.f_268440_)) {
                livingEntity.m_6469_(this.m_269291_().m_269374_((Entity)this), damage * 0.2f);
            }
            if ((item = livingEntity.m_21205_().m_41720_()) instanceof PickaxeItem) {
                damage *= 1.5f;
            }
        }
        if (projectileFlag) {
            damage *= 0.5f;
        }
        return super.m_6469_(source, damage);
    }

    @Override
    public void m_7822_(byte id) {
        if (id == 7) {
            AdvancedParticleBase.spawnParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.GLOW.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 14.0, 0.63, 1.0, 1.0, 1.0, 1.0, 28.0, true, true, false, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new AnimData.KeyTrack(new float[]{0.0f, 0.6f, 0.6f, 0.0f}, new float[]{0.0f, 0.3f, 0.8f, 1.0f}), false), new ParticleComponent.PinLocationWithEntity((Entity)this, new Vec3(0.0, (double)this.m_20206_() * 0.75, 0.0))});
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ACTIVE, (Object)false);
        this.f_19804_.m_135372_(DATA_ALWAYS_ACTIVE, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(DATA_ACTIVE, (Object)compound.m_128471_("isActive"));
        this.f_19804_.m_135381_(DATA_ALWAYS_ACTIVE, (Object)compound.m_128471_("isAlwaysActive"));
        this.active = this.isActive();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("isActive", ((Boolean)this.f_19804_.m_135370_(DATA_ACTIVE)).booleanValue());
        compound.m_128379_("isAlwaysActive", ((Boolean)this.f_19804_.m_135370_(DATA_ALWAYS_ACTIVE)).booleanValue());
    }

    public void m_8127_() {
        super.m_8127_();
        this.f_20884_ = 0.0f;
        this.f_20883_ = 0.0f;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        this.m_146922_(0.0f);
        this.f_20885_ = this.m_146908_();
        this.m_146867_();
        return super.m_6518_(level, instance, spawnType, groupData, tag);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.f_20883_ = 0.0f;
        this.f_20884_ = 0.0f;
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ACTIVE);
    }

    public void setActive(boolean isActive) {
        this.f_19804_.m_135381_(DATA_ACTIVE, (Object)isActive);
        this.deactivateTick = 0;
    }

    public boolean isAlwaysActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ALWAYS_ACTIVE);
    }

    public void setAlwaysActive(boolean alwaysActive) {
        this.f_19804_.m_135381_(DATA_ALWAYS_ACTIVE, (Object)alwaysActive);
    }

    @Override
    public Animation[] getAnimations() {
        return this.animations;
    }

    @Override
    public Animation getDeathAnimation() {
        return this.dieAnimation;
    }

    @Override
    public Animation getHurtAnimation() {
        return this.hurtAnimation;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundInit.GS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.GS_DEATH.get();
    }

    @Override
    public boolean isGlow() {
        return this.isActive() && this.m_6084_();
    }

    public static AttributeSupplier.Builder setAttributes() {
        return EntityGulingSentinel.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 18.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 10.0);
    }

    private static class NoneRotationControl
    extends BodyRotationControl {
        public NoneRotationControl(Mob mob) {
            super(mob);
        }

        public void m_8121_() {
        }
    }

    private static class GSLookAtTargetGoal
    extends Goal {
        private final EntityGulingSentinel entity;

        public GSLookAtTargetGoal(EntityGulingSentinel entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            boolean noAnimationFlag = this.entity.getAnimation() == this.entity.getAnimation();
            return noAnimationFlag && target != null && target.m_6084_() && this.entity.m_21574_().m_148306_((Entity)target);
        }

        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            if (target != null && target.m_6084_() && this.entity.m_21574_().m_148306_((Entity)target)) {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
        }
    }
}

