/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.item;

import com.eeeab.animate.client.util.ItemAnimationUtils;
import com.eeeab.eeeabsmobs.EEEABMobs;
import com.eeeab.eeeabsmobs.sever.ability.AbilityHandler;
import com.eeeab.eeeabsmobs.sever.capability.AbilityCapability;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.item.ConfigurableItem;
import com.eeeab.eeeabsmobs.sever.item.IUnbreakableItem;
import com.eeeab.eeeabsmobs.sever.util.EMTUtils;
import com.eeeab.eeeabsmobs.sever.util.EMTagKey;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class ItemDemolisher
extends SwordItem
implements ConfigurableItem,
IUnbreakableItem {
    private static final Predicate<ItemStack> SUPPORTED_PROJECTILES_PREDICATE = stack -> stack.m_204117_(EMTagKey.DEMOLISHER_SUPPORTED_PROJECTILES);
    private static final Component MELEE_MODE = EMTUtils.simpleText("other.", "melee_mode", ChatFormatting.YELLOW, new Object[0]);
    private static final Component RANGED_MODE = EMTUtils.simpleText("other.", "ranged_mode", ChatFormatting.YELLOW, new Object[0]);
    private Multimap<Attribute, AttributeModifier> defaultModifiers = this.creatAttributesFromConfig();

    public ItemDemolisher(Tier tier, Item.Properties properties) {
        super(tier, (int)(-3.0 + EMConfigHandler.COMMON.ITEM.DEMOLISHER_TOOL.attackDamageValue), (float)(-4.0 + EMConfigHandler.COMMON.ITEM.DEMOLISHER_TOOL.attackSpeedValue), properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)EEEABMobs.PROXY.getISTERProperties());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        boolean shiftFlag = player.m_6144_();
        if (shiftFlag) {
            player.m_21011_(usedHand, true);
            ItemDemolisher.changeWeaponState(itemStack);
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (ItemDemolisher.getWeaponState(itemStack) == 0) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        ItemStack projectile = ItemDemolisher.getProjectile(itemStack, player);
        if (projectile.m_41619_() && !player.m_150110_().f_35937_) {
            player.m_5661_(EMTUtils.simpleOtherText(this.m_5524_(), null, new Object[0]), true);
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)usedHand);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack itemStack, int remainingUseDuration) {
        Player player;
        AbilityCapability.IAbilityCapability capability;
        if (livingEntity instanceof Player && (capability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)(player = (Player)livingEntity))) != null) {
            boolean instabuild = !player.m_150110_().f_35937_;
            ItemStack projectile = ItemDemolisher.getProjectile(itemStack, player);
            if (player.m_36335_().m_41519_((Item)this)) {
                return;
            }
            if (projectile.m_41619_() && instabuild) {
                player.m_5661_(EMTUtils.simpleOtherText(this.m_5524_(), null, new Object[0]), true);
                player.m_5810_();
                return;
            }
            player.m_36335_().m_41524_((Item)this, (int)((Double)EMConfigHandler.COMMON.ITEM.itemHowitzerCoolingTime.get() * 20.0));
            if (!level.f_46443_) {
                AbilityHandler.INSTANCE.sendAbilityMessage(player, AbilityHandler.HOWITZER_ABILITY_TYPE);
            } else {
                ItemAnimationUtils.start(itemStack, player.f_19797_);
            }
            if (instabuild) {
                projectile.m_41774_(1);
                if (projectile.m_41619_()) {
                    player.m_150109_().m_36057_(projectile);
                }
            }
            player.m_5810_();
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        boolean flag = ItemDemolisher.getWeaponState(stack) == 1;
        Component component = EMTUtils.simpleText("item.", this.m_5524_(), ChatFormatting.GRAY, ".tip", flag ? RANGED_MODE : MELEE_MODE);
        if (flag) {
            if (EMTUtils.SHOW_ITEM_CD) {
                tooltip.add(EMTUtils.itemCoolTime((Double)EMConfigHandler.COMMON.ITEM.itemHowitzerCoolingTime.get()));
            }
            tooltip.add(component);
            tooltip.add(EMTUtils.simpleText("item.", this.m_5524_(), ChatFormatting.GRAY, ".tip_1", EMConfigHandler.COMMON.ITEM.itemHowitzerGrenadeDamage.get()));
        } else {
            tooltip.add(component);
            tooltip.add(EMTUtils.simpleText("item.", this.m_5524_(), ChatFormatting.GRAY, ".tip_2", new Object[0]));
        }
        tooltip.add(EMTUtils.simpleText("item.", this.m_5524_(), ChatFormatting.GRAY, ".tip_3", new Object[0]));
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.SWORD_DIG == toolAction;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> creatAttributesFromConfig() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", EMConfigHandler.COMMON.ITEM.DEMOLISHER_TOOL.attackDamageValue - 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", EMConfigHandler.COMMON.ITEM.DEMOLISHER_TOOL.attackSpeedValue - 4.0, AttributeModifier.Operation.ADDITION));
        return builder.build();
    }

    @Override
    public void refreshAttributesFromConfig() {
        this.defaultModifiers = this.creatAttributesFromConfig();
    }

    @Override
    public boolean canBreakItem() {
        return false;
    }

    public static ItemStack getProjectile(ItemStack itemStack, Player player) {
        ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)player, SUPPORTED_PROJECTILES_PREDICATE);
        if (!itemstack.m_41619_()) {
            return ForgeHooks.getProjectile((LivingEntity)player, (ItemStack)itemStack, (ItemStack)itemstack);
        }
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStackIn = inventory.m_8020_(i);
            if (!SUPPORTED_PROJECTILES_PREDICATE.test(itemStackIn)) continue;
            return ForgeHooks.getProjectile((LivingEntity)player, (ItemStack)itemStack, (ItemStack)itemStackIn);
        }
        return ItemStack.f_41583_;
    }

    public static int getWeaponState(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_("demolisherState") : 0;
    }

    public static void changeWeaponState(ItemStack stack) {
        CompoundTag tag;
        tag.m_128405_("demolisherState", (tag = stack.m_41784_()).m_128451_("demolisherState") == 0 ? 1 : 0);
    }
}

