/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.block.AnomalyBlock;
import biomesoplenty.init.ModTags;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class AnomalyFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.m_8055_(pos).m_60734_() == Blocks.f_50259_ || world.m_8055_(pos).m_60734_() == BOPBlocks.UNMAPPED_END_STONE;
    protected SimpleBlockPredicate replace = (world, pos) -> world.m_8055_(pos).m_204336_(BlockTags.f_278411_) || world.m_8055_(pos).m_60734_() instanceof BushBlock || world.m_8055_(pos).m_204336_(ModTags.Blocks.NULL_REPLACEABLE);

    public AnomalyFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        int z;
        int x;
        int y;
        int anomalyHeight;
        WorldGenLevel world = featurePlaceContext.m_159774_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        RandomSource rand = featurePlaceContext.m_225041_();
        BlockPos startPos = featurePlaceContext.m_159777_();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.m_159778_();
        while (startPos.m_123342_() >= world.m_141937_() + 1 && !this.placeOn.matches(world, startPos)) {
            startPos = startPos.m_7495_();
        }
        if (!this.placeOn.matches(world, startPos.m_7918_(0, 0, 0))) {
            return false;
        }
        int size = rand.m_188503_(3) + 2;
        if (!this.checkSpace(world, startPos, size, anomalyHeight = rand.m_188503_(4))) {
            return false;
        }
        BlockPos pos = startPos;
        for (y = 4; y > -128; --y) {
            for (x = -3; x <= size + 3; ++x) {
                for (z = -3; z <= size + 3; ++z) {
                    if (x == -3 || x == size + 3 || z == -3 || z == size + 3) {
                        if ((x == -3 || x == size + 3) && (z == -3 || z == size + 3) || rand.m_188503_(4) != 0 || world.m_8055_(pos.m_7918_(x, y, z)).m_60734_() == BOPBlocks.NULL_BLOCK) continue;
                        if (world.m_8055_(pos.m_7918_(x, y, z)).m_204336_(BlockTags.f_278411_)) {
                            this.setBlock(world, pos.m_7918_(x, y, z), Blocks.f_50016_.m_49966_());
                            continue;
                        }
                        this.setBlock(world, pos.m_7918_(x, y, z), BOPBlocks.NULL_END_STONE.m_49966_());
                        continue;
                    }
                    if (x == -2 || x == size + 2 || z == -2 || z == size + 2) {
                        if ((x == -2 || x == size + 2) && (z == -2 || z == size + 2) || world.m_8055_(pos.m_7918_(x, y, z)).m_60734_() == BOPBlocks.NULL_BLOCK) continue;
                        if (world.m_8055_(pos.m_7918_(x, y, z)).m_204336_(BlockTags.f_278411_)) {
                            this.setBlock(world, pos.m_7918_(x, y, z), Blocks.f_50016_.m_49966_());
                            continue;
                        }
                        this.setBlock(world, pos.m_7918_(x, y, z), BOPBlocks.NULL_END_STONE.m_49966_());
                        continue;
                    }
                    if (x == -1 || x == size + 1 || z == -1 || z == size + 1) {
                        if (!(x != -1 && x != size + 1 || z != -1 && z != size + 1)) {
                            if (world.m_8055_(pos.m_7918_(x, y, z)).m_204336_(BlockTags.f_278411_)) {
                                this.setBlock(world, pos.m_7918_(x, y, z), Blocks.f_50016_.m_49966_());
                                continue;
                            }
                            this.setBlock(world, pos.m_7918_(x, y, z), BOPBlocks.NULL_END_STONE.m_49966_());
                            continue;
                        }
                        if (world.m_8055_(pos.m_7918_(x, y, z)).m_204336_(BlockTags.f_278411_)) {
                            this.setBlock(world, pos.m_7918_(x, y, z), Blocks.f_50016_.m_49966_());
                            continue;
                        }
                        this.setBlock(world, pos.m_7918_(x, y, z), BOPBlocks.NULL_BLOCK.m_49966_());
                        continue;
                    }
                    this.setBlock(world, pos.m_7918_(x, y, z), Blocks.f_50016_.m_49966_());
                }
            }
        }
        for (y = 0; y <= size; ++y) {
            for (x = 0; x <= size; ++x) {
                for (z = 0; z <= size; ++z) {
                    AnomalyBlock.AnomalyType type = AnomalyBlock.AnomalyType.STABLE;
                    if (y == 0 || y == size || x == 0 || x == size || z == 0 || z == size) {
                        switch (rand.m_188503_(6)) {
                            default: {
                                type = AnomalyBlock.AnomalyType.VOLATILE;
                                break;
                            }
                            case 1: {
                                type = AnomalyBlock.AnomalyType.QUIRKY;
                                break;
                            }
                            case 2: {
                                type = AnomalyBlock.AnomalyType.UNSTABLE;
                            }
                        }
                    }
                    world.m_7731_(pos.m_7918_(x, anomalyHeight + y, z), (BlockState)BOPBlocks.ANOMALY.m_49966_().m_61124_(AnomalyBlock.ANOMALY_TYPE, (Comparable)((Object)type)), 2);
                }
            }
        }
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.m_5974_((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos, int size, int anomalyHeight) {
        for (int y = 0; y <= size; ++y) {
            for (int x = 0; x <= size; ++x) {
                for (int z = 0; z <= size; ++z) {
                    BlockPos pos1 = pos.m_7918_(x, anomalyHeight + y, z);
                    if (pos1.m_123342_() < 255 && (world.m_8055_(pos1).m_60795_() || world.m_8055_(pos1).m_60734_() == BOPBlocks.ANOMALY)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

