/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.TntBehavior;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventsHandler;
import net.mehvahdjukaar.supplementaries.common.items.BombItem;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SlingshotProjectileEntity
extends ImprovedProjectileEntity
implements IExtraClientSpawnData {
    private static final EntityDataAccessor<Byte> LOYALTY = SynchedEntityData.m_135353_(SlingshotProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected int MAX_AGE = 700;
    private float xRotInc;
    private float yRotInc;
    private float particleCooldown = 0.0f;
    private final Supplier<Integer> light = Suppliers.memoize(() -> {
        Item item = this.m_7846_().m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block b = blockItem.m_40614_();
            return b.m_49966_().m_60791_();
        }
        return 0;
    });

    public SlingshotProjectileEntity(Level world, ItemStack item, ItemStack throwerStack, @Nullable LivingEntity thrower) {
        this(world, item, throwerStack);
        if (thrower != null) {
            this.m_6034_(thrower.m_20185_(), thrower.m_20188_() - 0.1, thrower.m_20189_());
            this.m_5602_((Entity)thrower);
        }
    }

    public SlingshotProjectileEntity(Level world, ItemStack item, ItemStack throwerStack) {
        super(ModEntities.SLINGSHOT_PROJECTILE.get(), world);
        this.maxAge = this.MAX_AGE;
        this.m_37446_(item);
        this.setLoyalty((byte)EnchantmentHelper.m_44928_((ItemStack)throwerStack));
        this.m_20242_(EnchantmentHelper.m_44843_((Enchantment)ModRegistry.STASIS_ENCHANTMENT.get(), (ItemStack)throwerStack) != 0);
        this.yRotInc = (float)(this.f_19796_.m_188499_() ? 1 : -1) * (float)(4.0 * this.f_19796_.m_188583_() + 7.0);
        this.xRotInc = (float)(this.f_19796_.m_188499_() ? 1 : -1) * (float)(4.0 * this.f_19796_.m_188583_() + 7.0);
        this.m_146926_(this.f_19796_.m_188501_() * 360.0f);
        this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.maxStuckTime = 0;
    }

    public SlingshotProjectileEntity(EntityType<SlingshotProjectileEntity> type, Level world) {
        super(type, world);
        this.maxAge = this.MAX_AGE;
        this.maxStuckTime = 0;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return PlatHelper.getEntitySpawnPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOYALTY, (Object)0);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setLoyalty(tag.m_128445_("Loyalty"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("Loyalty", this.getLoyalty());
    }

    private void setLoyalty(byte loyalty) {
        this.f_19804_.m_135381_(LOYALTY, (Object)loyalty);
    }

    public byte getLoyalty() {
        return (Byte)this.f_19804_.m_135370_(LOYALTY);
    }

    protected Item m_7881_() {
        return Items.f_41905_;
    }

    protected void m_5790_(EntityHitResult entityRayTraceResult) {
        Entity entity;
        super.m_5790_(entityRayTraceResult);
        ItemStack stack = this.m_7846_();
        if (!this.trySplashPotStuff() && (entity = entityRayTraceResult.m_82443_()) instanceof EnderMan) {
            BlockItem bi;
            Block block;
            EnderMan enderman = (EnderMan)entity;
            Item item = stack.m_41720_();
            if (item instanceof BlockItem && ((block = (bi = (BlockItem)item).m_40614_()).m_204297_().m_203656_(BlockTags.f_13046_) || CommonConfigs.Tools.UNRESTRICTED_SLINGSHOT.get().booleanValue()) && enderman.m_32530_() == null) {
                enderman.m_32521_(block.m_49966_());
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (stack.m_204117_(ModTags.SLINGSHOT_DAMAGEABLE)) {
            float speed = (float)this.m_20184_().m_82553_();
            double baseDamage = CommonConfigs.Tools.SLINGSHOT_DAMAGEABLE_DAMAGE.get();
            int damage = Mth.m_14165_((double)Mth.m_14008_((double)((double)speed * baseDamage), (double)0.0, (double)2.147483647E9));
            entityRayTraceResult.m_82443_().m_6469_(ModDamageSources.slingshot((Entity)this, this.m_19749_()), (float)damage);
            this.m_6074_();
        }
    }

    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        Entity owner = this.m_19749_();
        Level level = this.m_9236_();
        boolean shoulKill = this.trySplashPotStuff();
        if (!shoulKill && owner instanceof Player) {
            Player player = (Player)owner;
            if (!Utils.mayPerformBlockAction((Player)player, (BlockPos)hit.m_82425_(), (ItemStack)this.m_7846_())) {
                return;
            }
            if (CompatHandler.FLAN && (level.f_46443_ || !FlanCompat.canPlace(player, hit.m_82425_()))) {
                return;
            }
        }
        if (!shoulKill) {
            Player p;
            ItemStack stack = this.m_7846_();
            Item item = stack.m_41720_();
            Player player = owner instanceof Player ? (p = (Player)owner) : FakePlayerManager.getDefault((Entity)this, (Entity)this);
            InteractionResult overrideResult = InteractEventsHandler.onItemUsedOnBlockHP(player, level, stack, InteractionHand.MAIN_HAND, hit);
            if (overrideResult.m_19077_()) {
                shoulKill = true;
            } else {
                overrideResult = InteractEventsHandler.onItemUsedOnBlock(player, level, stack, InteractionHand.MAIN_HAND, hit);
                if (overrideResult.m_19077_()) {
                    shoulKill = true;
                }
            }
            if (!shoulKill) {
                Player fakePlayer = FakePlayerManager.getDefault((Entity)this, (Entity)player);
                BlockPlaceContext context = new BlockPlaceContext(level, fakePlayer, InteractionHand.MAIN_HAND, this.m_7846_(), hit);
                shoulKill = ItemsUtil.place(item, context).m_19077_();
                if (CommonConfigs.Functional.CANNON_EXPLODE_TNT.get().booleanValue() && level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    BlockPos pos = context.m_8083_();
                    BlockState placed = level.m_8055_(pos);
                    TntBehavior.tryExplodeTNTHack(sl, pos.m_252807_(), placed.m_60734_(), pos);
                }
            }
            if (!shoulKill && item instanceof DispensibleContainerItem) {
                DispensibleContainerItem dc = (DispensibleContainerItem)item;
                if (item.m_41470_()) {
                    Item craftingRemainingItem = stack.m_41720_().m_41469_();
                    SuppPlatformStuff.dispenseContent(dc, stack, hit, level, player);
                    dc.m_142131_(player, level, stack, hit.m_82425_());
                    if (craftingRemainingItem != null) {
                        this.m_37446_(craftingRemainingItem.m_7968_());
                    } else {
                        shoulKill = true;
                    }
                }
            }
            this.isStuck = true;
        }
        if (shoulKill) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private boolean trySplashPotStuff() {
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            Object ent = null;
            Item item = this.m_7846_().m_41720_();
            Level level = this.m_9236_();
            if (item instanceof ThrowablePotionItem) {
                ThrownPotion p = new ThrownPotion(level, le);
                p.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                p.m_37446_(this.m_7846_());
                ent = p;
            } else if (item == Items.f_42613_) {
                SmallFireball p = new SmallFireball(level, le, this.m_20185_(), this.m_20186_(), this.m_20189_());
                p.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                p.m_37010_(this.m_7846_());
                ent = p;
            } else if (item instanceof SnowballItem) {
                Snowball s = new Snowball(level, le);
                s.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                s.m_37446_(this.m_7846_());
                ent = s;
            } else if (item instanceof BombItem) {
                BombItem bi = (BombItem)item;
                BombEntity s = new BombEntity(level, le, bi.getType());
                s.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                s.m_37446_(this.m_7846_());
                ent = s;
            } else if (item instanceof EnderpearlItem) {
                ThrownEnderpearl s = new ThrownEnderpearl(level, le);
                s.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                s.m_37446_(this.m_7846_());
                ent = s;
            }
            if (ent != null) {
                level.m_7967_(ent);
                ent.m_8119_();
                return true;
            }
        }
        return false;
    }

    public void m_8119_() {
        if (this.isNoPhysics()) {
            byte loyaltyLevel = this.getLoyalty();
            Entity owner = this.m_19749_();
            if (loyaltyLevel > 0 && this.isAcceptableReturnOwner(owner)) {
                Vec3 force = new Vec3(owner.m_20185_() - this.m_20185_(), owner.m_20188_() - this.m_20186_(), owner.m_20189_() - this.m_20189_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + force.f_82480_ * 0.015 * (double)loyaltyLevel, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)loyaltyLevel;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(force.m_82541_().m_82490_(d0)));
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptableReturnOwner(Entity owner) {
        if (owner != null && owner.m_6084_()) {
            return !(owner instanceof ServerPlayer) || !owner.m_5833_();
        }
        return false;
    }

    public void m_6123_(Player playerEntity) {
        if (!this.m_9236_().f_46443_ && this.hasLeftOwner() && (this.isNoPhysics() || this.isStuck)) {
            boolean success = playerEntity.m_150110_().f_35937_ || playerEntity.m_150109_().m_36054_(this.m_7846_());
            Level level = this.m_9236_();
            if (!success) {
                this.m_5552_(this.m_7846_(), 0.1f);
            } else {
                level.m_6269_(null, (Entity)playerEntity, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 1.4f + 2.0f);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean hasReachedEndOfLife() {
        if (this.m_20068_() && this.m_20184_().m_82556_() < 0.005) {
            return true;
        }
        return super.hasReachedEndOfLife();
    }

    public void reachedEndOfLife() {
        if (this.getLoyalty() != 0 && this.isAcceptableReturnOwner(this.m_19749_())) {
            this.setNoPhysics(true);
            this.stuckTime = 0;
        } else {
            this.m_5552_(this.m_7846_(), 0.1f);
            super.reachedEndOfLife();
        }
    }

    protected void m_37283_() {
        if (!this.m_20068_()) {
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            this.m_146926_(this.m_146909_() + this.xRotInc);
            this.m_146922_(this.m_146908_() + this.yRotInc);
            this.particleCooldown += 1.0f;
        } else {
            super.m_37283_();
        }
    }

    public void spawnTrailParticles() {
        super.spawnTrailParticles();
        if (!this.isNoPhysics()) {
            double speed = this.m_20184_().m_82553_();
            if (this.f_19797_ > 1 && speed * (double)this.f_19797_ > 1.5) {
                if (this.m_20068_()) {
                    Vec3 rot = new Vec3(0.325, 0.0, 0.0).m_82524_((float)this.f_19797_ * 0.32f);
                    Vec3 movement = this.m_20184_();
                    Vec3 offset = MthUtils.changeBasisN((Vec3)movement, (Vec3)rot);
                    double px = this.m_20185_() + offset.f_82479_;
                    double py = this.m_20188_() + offset.f_82480_;
                    double pz = this.m_20189_() + offset.f_82481_;
                    movement = movement.m_82490_(0.25);
                    this.m_9236_().m_7106_((ParticleOptions)ModParticles.STASIS_PARTICLE.get(), px, py, pz, movement.f_82479_, movement.f_82480_, movement.f_82481_);
                } else {
                    double interval = 3.0 / (speed * 0.95 + 0.05);
                    if ((double)this.particleCooldown > interval) {
                        this.particleCooldown = (float)((double)this.particleCooldown - interval);
                        double x = this.m_20185_();
                        double y = this.m_20188_();
                        double z = this.m_20189_();
                        this.m_9236_().m_7106_((ParticleOptions)ModParticles.SLINGSHOT_PARTICLE.get(), x, y, z, 0.0, 0.01, 0.0);
                    }
                }
            }
        }
    }

    protected float getInertia() {
        return this.m_20068_() ? (float)CommonConfigs.Tools.SLINGSHOT_DECELERATION.get().doubleValue() : super.getInertia();
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Entity entity = this.m_19749_();
        int id = -1;
        if (entity != null) {
            id = entity.m_19879_();
        }
        buffer.writeInt(id);
        buffer.writeFloat(this.xRotInc);
        buffer.writeFloat(this.yRotInc);
        buffer.writeFloat(this.m_146909_());
        buffer.writeFloat(this.m_146908_());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        int id = buffer.readInt();
        if (id != -1) {
            this.m_5602_(this.m_9236_().m_6815_(id));
        }
        this.xRotInc = buffer.readFloat();
        this.yRotInc = buffer.readFloat();
        this.m_146926_(buffer.readFloat());
        this.m_146922_(buffer.readFloat());
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
    }

    public int getLightEmission() {
        return this.light.get();
    }
}

