/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.multiblock;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.common.multiblock.IMasterLogic;
import slimeknights.tconstruct.common.multiblock.IServantLogic;
import slimeknights.tconstruct.library.utils.TagUtil;

public class ServantTileEntity
extends MantleBlockEntity
implements IServantLogic {
    private static final String TAG_MASTER_POS = "masterOffset";
    private static final String TAG_MASTER_BLOCK = "masterBlock";
    @Nullable
    private BlockPos masterPos;
    @Nullable
    private Block masterBlock;

    public ServantTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean hasMaster() {
        return this.masterPos != null;
    }

    protected void setMaster(@Nullable BlockPos master, @Nullable Block block) {
        this.masterPos = master;
        this.masterBlock = block;
        this.setChangedFast();
    }

    protected boolean validateMaster() {
        if (this.masterPos == null) {
            return false;
        }
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_8055_(this.masterPos).m_60734_() == this.masterBlock) {
            return true;
        }
        this.setMaster(null, null);
        return false;
    }

    @Override
    public boolean isValidMaster(IMasterLogic master) {
        if (this.validateMaster()) {
            return master.getMasterPos().equals((Object)this.masterPos);
        }
        return true;
    }

    @Override
    public void notifyMasterOfChange(BlockPos pos, BlockState state) {
        if (this.validateMaster()) {
            assert (this.masterPos != null);
            BlockEntityHelper.get(IMasterLogic.class, (BlockGetter)this.f_58857_, (BlockPos)this.masterPos).ifPresent(te -> te.notifyChange(pos, state));
        }
    }

    @Override
    public void setPotentialMaster(IMasterLogic master) {
        BlockPos newMaster = master.getMasterPos();
        if (newMaster.equals((Object)this.masterPos)) {
            this.masterBlock = master.getMasterBlock().m_60734_();
            this.setChangedFast();
        } else if (!this.validateMaster()) {
            this.setMaster(newMaster, master.getMasterBlock().m_60734_());
        }
    }

    @Override
    public void removeMaster(IMasterLogic master) {
        if (this.masterPos != null && this.masterPos.equals((Object)master.getMasterPos())) {
            this.setMaster(null, null);
        }
    }

    protected void readMaster(CompoundTag tags) {
        ResourceLocation masterBlockName;
        BlockPos masterPos = TagUtil.readOptionalPos(tags, TAG_MASTER_POS, this.f_58858_);
        Block masterBlock = null;
        if (masterPos != null && tags.m_128425_(TAG_MASTER_BLOCK, 8) && (masterBlockName = ResourceLocation.m_135820_((String)tags.m_128461_(TAG_MASTER_BLOCK))) != null && ForgeRegistries.BLOCKS.containsKey(masterBlockName)) {
            masterBlock = (Block)ForgeRegistries.BLOCKS.getValue(masterBlockName);
        }
        if (masterBlock != null) {
            this.masterPos = masterPos;
            this.masterBlock = masterBlock;
        }
    }

    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        this.readMaster(tags);
    }

    protected CompoundTag writeMaster(CompoundTag tags) {
        if (this.masterPos != null && this.masterBlock != null) {
            tags.m_128365_(TAG_MASTER_POS, (Tag)NbtUtils.m_129224_((BlockPos)this.masterPos.m_121996_((Vec3i)this.f_58858_)));
            tags.m_128359_(TAG_MASTER_BLOCK, BuiltInRegistries.f_256975_.m_7981_((Object)this.masterBlock).toString());
        }
        return tags;
    }

    public void m_183515_(CompoundTag tags) {
        super.m_183515_(tags);
        this.writeMaster(tags);
    }

    @Override
    @Nullable
    public BlockPos getMasterPos() {
        return this.masterPos;
    }
}

