/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;

public record RandomLevelingValue(float flat, float perLevel, float randomBonus) {
    public static final RecordLoadable<RandomLevelingValue> LOADABLE = RecordLoadable.create((RecordField)FloatLoadable.ANY.defaultField("flat", (Object)Float.valueOf(0.0f), RandomLevelingValue::flat), (RecordField)FloatLoadable.ANY.defaultField("per_level", (Object)Float.valueOf(0.0f), RandomLevelingValue::perLevel), (RecordField)FloatLoadable.ANY.defaultField("random", (Object)Float.valueOf(0.0f), RandomLevelingValue::randomBonus), RandomLevelingValue::new);

    public float computeValue(float level) {
        float value = this.flat + this.perLevel * level;
        if (this.randomBonus > 0.0f && level > 0.0f) {
            value += TConstruct.RANDOM.nextFloat() * level * this.randomBonus;
        }
        return value;
    }

    @Deprecated(forRemoval=true)
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        LOADABLE.serialize((Object)this, json);
        return json;
    }

    @Deprecated(forRemoval=true)
    public static RandomLevelingValue deserialize(JsonObject json) {
        return (RandomLevelingValue)LOADABLE.deserialize(json);
    }

    @Deprecated(forRemoval=true)
    public static RandomLevelingValue get(JsonObject parent, String key) {
        return (RandomLevelingValue)LOADABLE.getIfPresent(parent, key);
    }

    @Deprecated(forRemoval=true)
    public void toNetwork(FriendlyByteBuf buffer) {
        LOADABLE.encode(buffer, (Object)this);
    }

    @Deprecated(forRemoval=true)
    public static RandomLevelingValue fromNetwork(FriendlyByteBuf buffer) {
        return (RandomLevelingValue)LOADABLE.decode(buffer);
    }

    public static RandomLevelingValue flat(float value) {
        return new RandomLevelingValue(value, 0.0f, 0.0f);
    }

    public static RandomLevelingValue perLevel(float flat, float leveling) {
        return new RandomLevelingValue(flat, leveling, 0.0f);
    }

    public static RandomLevelingValue random(float flat, float random) {
        return new RandomLevelingValue(flat, 0.0f, random);
    }
}

