/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.material;

import java.util.List;
import net.minecraft.world.item.ArmorItem;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairToolHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.modules.ArmorModuleBuilder;

public record StatlessPartRepairModule(int partIndex, int repairAmount) implements MaterialRepairToolHook,
ToolModule
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolHooks.MATERIAL_REPAIR);
    public static final RecordLoadable<StatlessPartRepairModule> LOADER = RecordLoadable.create((RecordField)IntLoadable.FROM_ZERO.requiredField("part_index", StatlessPartRepairModule::partIndex), (RecordField)IntLoadable.FROM_ONE.requiredField("repair_amount", StatlessPartRepairModule::repairAmount), StatlessPartRepairModule::new);

    public static ArmorBuilder armor(int partIndex) {
        return new ArmorBuilder(partIndex);
    }

    public RecordLoadable<? extends GenericLoaderRegistry.IHaveLoader> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public boolean isRepairMaterial(IToolStackView tool, MaterialId material) {
        return material.equals(tool.getMaterial(this.partIndex).getId());
    }

    @Override
    public float getRepairAmount(IToolStackView tool, MaterialId material) {
        return this.isRepairMaterial(tool, material) ? (float)this.repairAmount : 0.0f;
    }

    public static class ArmorBuilder
    implements ArmorModuleBuilder<StatlessPartRepairModule> {
        private final int partIndex;
        private final int[] durability = new int[4];

        public ArmorBuilder durabilityFactor(float maxDamageFactor) {
            for (ArmorItem.Type slotType : ArmorItem.Type.values()) {
                int index = slotType.ordinal();
                this.durability[index] = (int)((float)ArmorModuleBuilder.MAX_DAMAGE_ARRAY[index] * maxDamageFactor);
            }
            return this;
        }

        @Override
        public StatlessPartRepairModule build(ArmorItem.Type slot) {
            return new StatlessPartRepairModule(this.partIndex, this.durability[slot.ordinal()]);
        }

        private ArmorBuilder(int partIndex) {
            this.partIndex = partIndex;
        }
    }
}

