/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.transfer;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.menu.ReadOnlySlot;
import slimeknights.tconstruct.tools.menu.ToolContainerMenu;

@ApiStatus.Internal
public class ToolInventoryTransferInfo
implements IRecipeTransferHandler<ToolContainerMenu, CraftingRecipe>,
IRecipeTransferInfo<ToolContainerMenu, CraftingRecipe> {
    private static final IntSet PLAYER_INV_INDEXES = IntArraySet.of((int[])new int[]{0, 1, 3, 4});
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IRecipeTransferHandler<ToolContainerMenu, CraftingRecipe> handler;

    public ToolInventoryTransferInfo(IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
        this.handler = handlerHelper.createUnregisteredRecipeTransferHandler((IRecipeTransferInfo)this);
    }

    public Class<? extends ToolContainerMenu> getContainerClass() {
        return ToolContainerMenu.class;
    }

    public Optional<MenuType<ToolContainerMenu>> getMenuType() {
        return Optional.of((MenuType)TinkerTools.toolContainer.get());
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(ToolContainerMenu container, CraftingRecipe recipe, IRecipeSlotsView recipeSlotsView, Player player, boolean maxTransfer, boolean doTransfer) {
        int slots = container.getToolInventoryStart() - 1;
        if (slots <= 0) {
            return this.handlerHelper.createInternalError();
        }
        if (!this.handlerHelper.recipeTransferHasServerSupport()) {
            MutableComponent tooltipMessage = Component.m_237115_((String)"jei.tooltip.error.recipe.transfer.no.server");
            return this.handlerHelper.createUserErrorWithTooltip((Component)tooltipMessage);
        }
        if (slots >= 9) {
            return this.handler.transferRecipe((AbstractContainerMenu)container, (Object)recipe, recipeSlotsView, player, maxTransfer, doTransfer);
        }
        List slotViews = recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT);
        if (!ToolInventoryTransferInfo.validateIngredientsOutsidePlayerGridAreEmpty(slotViews)) {
            MutableComponent tooltipMessage = Component.m_237115_((String)"jei.tooltip.error.recipe.transfer.too.large.player.inventory");
            return this.handlerHelper.createUserErrorWithTooltip((Component)tooltipMessage);
        }
        List<IRecipeSlotView> filteredSlotViews = ToolInventoryTransferInfo.filterSlots(slotViews);
        IRecipeSlotsView filteredRecipeSlots = this.handlerHelper.createRecipeSlotsView(filteredSlotViews);
        return this.handler.transferRecipe((AbstractContainerMenu)container, (Object)recipe, filteredRecipeSlots, player, maxTransfer, doTransfer);
    }

    public boolean canHandle(ToolContainerMenu container, CraftingRecipe recipe) {
        return true;
    }

    public List<Slot> getInventorySlots(ToolContainerMenu container, CraftingRecipe recipe) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int playerStart = container.getPlayerInventoryStart();
        for (int i = container.getToolInventoryStart(); i < container.f_38839_.size(); ++i) {
            Slot slot = container.m_38853_(i);
            if (slot instanceof ReadOnlySlot) continue;
            slots.add(container.m_38853_(i));
        }
        return slots;
    }

    public List<Slot> getRecipeSlots(ToolContainerMenu container, CraftingRecipe recipe) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 1; i < container.getToolInventoryStart(); ++i) {
            slots.add(container.m_38853_(i));
        }
        return slots;
    }

    private static boolean validateIngredientsOutsidePlayerGridAreEmpty(List<IRecipeSlotView> slotViews) {
        int bound = slotViews.size();
        for (int i = 0; i < bound; ++i) {
            IRecipeSlotView slotView;
            if (PLAYER_INV_INDEXES.contains(i) || (slotView = slotViews.get(i)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static List<IRecipeSlotView> filterSlots(List<IRecipeSlotView> slotViews) {
        return PLAYER_INV_INDEXES.intStream().mapToObj(slotViews::get).toList();
    }
}

