/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.network;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.smeltery.block.entity.controller.HeatingStructureBlockEntity;

public class StructureErrorPositionPacket
implements IThreadsafePacket {
    private final BlockPos controllerPos;
    @Nullable
    private final BlockPos errorPos;

    public StructureErrorPositionPacket(FriendlyByteBuf buffer) {
        this.controllerPos = buffer.m_130135_();
        this.errorPos = buffer.readBoolean() ? buffer.m_130135_() : null;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.controllerPos);
        if (this.errorPos != null) {
            buffer.writeBoolean(true);
            buffer.m_130064_(this.errorPos);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    public StructureErrorPositionPacket(BlockPos controllerPos, @Nullable BlockPos errorPos) {
        this.controllerPos = controllerPos;
        this.errorPos = errorPos;
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(StructureErrorPositionPacket packet) {
            BlockEntityHelper.get(HeatingStructureBlockEntity.class, (BlockGetter)Minecraft.m_91087_().f_91073_, (BlockPos)packet.controllerPos).ifPresent(te -> te.setErrorPos(packet.errorPos));
        }
    }
}

