/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal;

import dev.obscuria.lootjournal.ModConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class LootJournal {
    public static final String MODID = "loot_journal";
    public static final ModConfig CONFIG = new ModConfig();
    public static boolean shouldRebuildTabs = true;

    public static ResourceLocation key(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static boolean isAllowed(ItemStack stack) {
        LootJournal.tryRebuildTabContents();
        Item item = stack.m_41720_();
        if (LootJournal.CONFIG.itemsWhitelist.contains(item)) {
            return true;
        }
        if (LootJournal.CONFIG.tabsWhitelist.stream().anyMatch(tab -> LootJournal.containsAny(tab, stack))) {
            return true;
        }
        if (LootJournal.CONFIG.defaultBehavior.isBlacklisted()) {
            return false;
        }
        if (LootJournal.CONFIG.itemsBlacklist.contains(item)) {
            return false;
        }
        return LootJournal.CONFIG.tabsBlacklist.stream().noneMatch(tab -> LootJournal.containsAny(tab, stack));
    }

    private static void tryRebuildTabContents() {
        if (!shouldRebuildTabs) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        shouldRebuildTabs = false;
        new CreativeModeInventoryScreen((Player)player, player.f_108617_.m_247016_(), ((Boolean)Minecraft.m_91087_().f_91066_.m_257871_().m_231551_()).booleanValue());
    }

    private static boolean containsAny(CreativeModeTab tab, ItemStack stack) {
        for (ItemStack inner : tab.m_260957_()) {
            if (!inner.m_150930_(stack.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public static void init() {
    }
}

