/*
 * Decompiled with CFR 0.152.
 */
package immersive_machinery.client.render.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import immersive_aircraft.entity.VehicleEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;

public class PathDebugRenderer {
    public static PathDebugRenderer INSTANCE = new PathDebugRenderer();
    Path path = null;
    int pathEntity = 0;

    public void setPath(Path path, VehicleEntity vehicle) {
        this.path = path;
        this.pathEntity = vehicle.m_19879_();
    }

    public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, Entity entity, float tickDelta) {
        Minecraft client = Minecraft.m_91087_();
        if (this.pathEntity == entity.m_19879_() && this.path != null && client.m_91290_().m_114377_()) {
            double x = Mth.m_14139_((double)tickDelta, (double)entity.f_19790_, (double)entity.m_20185_());
            double y = Mth.m_14139_((double)tickDelta, (double)entity.f_19791_, (double)entity.m_20186_());
            double z = Mth.m_14139_((double)tickDelta, (double)entity.f_19792_, (double)entity.m_20189_());
            this.renderPath(matrixStack, vertexConsumerProvider, this.path, x, y, z);
        }
    }

    void renderPath(PoseStack poseStack, MultiBufferSource buffer, Path path, double x, double y, double z) {
        this.renderPathLine(poseStack, buffer.m_6299_(RenderType.m_269399_((double)16.0)), path, x, y, z);
        BlockPos target = path.m_77406_();
        if (this.distanceToCamera(target, x, y, z) <= 80.0) {
            this.renderCube(poseStack, buffer, x, y, z, target, 0.0f, 1.0f, 0.0f);
            for (int i = 0; i < path.m_77398_(); ++i) {
                Node node = path.m_77375_(i);
                float red = i == path.m_77399_() ? 1.0f : 0.0f;
                float blue = i == path.m_77399_() ? 0.0f : 1.0f;
                this.renderCube(poseStack, buffer, x, y, z, node.m_77288_(), red, 0.0f, blue);
            }
        }
    }

    private void renderCube(PoseStack poseStack, MultiBufferSource buffer, double x, double y, double z, BlockPos target, float red, float green, float blue) {
        AABB cube = new AABB((double)((float)target.m_123341_() + 0.25f), (double)((float)target.m_123342_() + 0.25f), (double)target.m_123343_() + 0.25, (double)((float)target.m_123341_() + 0.75f), (double)((float)target.m_123342_() + 0.75f), (double)((float)target.m_123343_() + 0.75f)).m_82386_(-x, -y, -z);
        DebugRenderer.m_269311_((PoseStack)poseStack, (MultiBufferSource)buffer, (AABB)cube, (float)red, (float)green, (float)blue, (float)0.5f);
    }

    void renderPathLine(PoseStack poseStack, VertexConsumer consumer, Path path, double x, double y, double z) {
        for (int i = 0; i < path.m_77398_(); ++i) {
            Node node = path.m_77375_(i);
            if (this.distanceToCamera(node.m_77288_(), x, y, z) > 80.0) continue;
            float f = (float)i / (float)path.m_77398_() * 0.33f;
            int j = i == 0 ? 0 : Mth.m_14169_((float)f, (float)0.9f, (float)0.9f);
            int k = j >> 16 & 0xFF;
            int l = j >> 8 & 0xFF;
            int m = j & 0xFF;
            consumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)((double)node.f_77271_ - x + 0.5), (float)((double)node.f_77272_ - y + 0.5), (float)((double)node.f_77273_ - z + 0.5)).m_6122_(k, l, m, 255).m_5752_();
        }
    }

    private double distanceToCamera(BlockPos pos, double x, double y, double z) {
        return Math.abs((double)pos.m_123341_() - x) + Math.abs((double)pos.m_123342_() - y) + Math.abs((double)pos.m_123343_() - z);
    }
}

