/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FTBLibraryClientConfig;
import dev.ftb.mods.ftblibrary.config.ImageResourceConfig;
import dev.ftb.mods.ftblibrary.config.ResourceConfigValue;
import dev.ftb.mods.ftblibrary.config.ui.ResourceSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.ResourceSelectorScreen;
import dev.ftb.mods.ftblibrary.config.ui.SearchModeIndex;
import dev.ftb.mods.ftblibrary.config.ui.SelectableResource;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.util.ModUtils;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.Nullable;

public class SelectImageResourceScreen
extends ResourceSelectorScreen<ResourceLocation> {
    private static final ResourceSearchMode<ResourceLocation> ALL_IMAGES = new AllImagesMode();
    public static final SearchModeIndex<ResourceSearchMode<ResourceLocation>> KNOWN_MODES = new SearchModeIndex();
    private static final SelectableResource<ResourceLocation> NO_IMAGE = new SelectableResource.ImageResource(ImageResourceConfig.NONE);
    private static List<SelectableResource.ImageResource> cachedImages;

    public SelectImageResourceScreen(ResourceConfigValue<ResourceLocation> config, ConfigCallback callback) {
        super(config, callback);
    }

    private static void clearCachedImages() {
        cachedImages = null;
    }

    @Override
    protected ResourceSelectorScreen.ResourceButton makeResourceButton(Panel panel, @Nullable SelectableResource<ResourceLocation> resource) {
        return new ImageButton(panel, Objects.requireNonNullElse(resource, NO_IMAGE));
    }

    @Override
    protected SearchModeIndex<ResourceSearchMode<ResourceLocation>> getSearchModeIndex() {
        return KNOWN_MODES;
    }

    private static boolean isValidImage(ResourceLocation id) {
        return !id.m_135815_().startsWith("textures/font/");
    }

    static {
        KNOWN_MODES.appendMode(ALL_IMAGES);
        cachedImages = null;
    }

    private class ImageButton
    extends ResourceSelectorScreen.ResourceButton {
        protected ImageButton(Panel panel, SelectableResource<ResourceLocation> resource) {
            super(panel, resource);
        }

        @Override
        public boolean shouldAdd(String search) {
            if ((search = search.toLowerCase()).isEmpty()) {
                return true;
            }
            if (search.startsWith("@")) {
                return ((ResourceLocation)this.getStack()).m_135827_().contains(search.substring(1));
            }
            return ((ResourceLocation)this.getStack()).m_135815_().contains(search);
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            MutableComponent text = Component.m_237113_((String)((ResourceLocation)this.getStack()).m_135827_()).m_130940_(ChatFormatting.GOLD).m_130946_(":").m_7220_((Component)Component.m_237113_((String)((ResourceLocation)this.getStack()).m_135815_()).m_130940_(ChatFormatting.YELLOW));
            list.add((Component)text);
            if (((Boolean)FTBLibraryClientConfig.IMAGE_MODNAME.get()).booleanValue()) {
                ModUtils.getModName(((ResourceLocation)this.getStack()).m_135827_()).ifPresent(name -> list.add((Component)Component.m_237113_((String)name).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})));
            }
        }
    }

    private static class AllImagesMode
    implements ResourceSearchMode<ResourceLocation> {
        private AllImagesMode() {
        }

        @Override
        public Icon getIcon() {
            return Icons.ART;
        }

        @Override
        public MutableComponent getDisplayName() {
            return Component.m_237115_((String)"ftblibrary.select_image.all_images");
        }

        @Override
        public Collection<? extends SelectableResource<ResourceLocation>> getAllResources() {
            if (cachedImages == null) {
                ArrayList images = new ArrayList();
                StringUtils.ignoreResourceLocationErrors = true;
                Map textures = Collections.emptyMap();
                try {
                    textures = Minecraft.m_91087_().m_91098_().m_214159_("textures", t -> t.m_135815_().endsWith(".png"));
                }
                catch (Exception ex) {
                    FTBLibrary.LOGGER.error("A mod has a broken resource preventing this list from loading: " + String.valueOf(ex));
                }
                StringUtils.ignoreResourceLocationErrors = false;
                textures.keySet().forEach(rl -> {
                    if (!ResourceLocation.m_135830_((String)rl.toString())) {
                        FTBLibrary.LOGGER.warn("Image " + String.valueOf(rl) + " has invalid path! Report this to author of '" + rl.m_135827_() + "'!");
                    } else if (SelectImageResourceScreen.isValidImage(rl)) {
                        images.add(rl);
                    }
                });
                cachedImages = images.stream().sorted().map(res -> {
                    ResourceLocation res1 = new ResourceLocation(res.m_135827_(), res.m_135815_().substring(9, res.m_135815_().length() - 4));
                    TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(res1);
                    SpriteContents contents = sprite.m_245424_();
                    if (contents.m_246162_().equals((Object)MissingTextureAtlasSprite.m_118071_())) {
                        res1 = res;
                    }
                    return new SelectableResource.ImageResource(res1);
                }).toList();
            }
            return cachedImages;
        }
    }

    public static enum ResourceListener implements ResourceManagerReloadListener
    {
        INSTANCE;


        public void m_6213_(ResourceManager resourceManager) {
            SelectImageResourceScreen.clearCachedImages();
        }
    }
}

