/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.render.block_entity.FloatingFlowerBlockEntityRenderer;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;

public class SpecialFlowerBlockEntityRenderer<T extends SpecialFlowerBlockEntity>
implements BlockEntityRenderer<T> {
    public static final int INNER_ALPHA = 32;
    public static final int OUTER_ALPHA = 64;
    public static final float FRAME_WIDTH = 0.0625f;
    public static final float Y_OFFSET_INNER = 0.0625f;
    public static final float Y_OFFSET_OUTER = 0.078125f;
    public static final int TOTAL_ANGLES = 360;
    public static final double DEGREES_TO_RADIAN = Math.PI / 180;

    public SpecialFlowerBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(SpecialFlowerBlockEntity tile, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        boolean hasBindingAttempt;
        Entity entity;
        if (tile.isFloating()) {
            FloatingFlowerBlockEntityRenderer.renderFloatingIsland(tile, partialTicks, ms, buffers, overlay);
        }
        if (!((entity = Minecraft.m_91087_().f_91075_) instanceof LivingEntity)) {
            return;
        }
        LivingEntity view = (LivingEntity)entity;
        if (!ManaseerMonocleItem.hasMonocle(view)) {
            return;
        }
        BlockPos pos = null;
        HitResult ray = Minecraft.m_91087_().f_91077_;
        if (ray != null && ray.m_6662_() == HitResult.Type.BLOCK) {
            pos = ((BlockHitResult)ray).m_82425_();
        }
        if ((hasBindingAttempt = SpecialFlowerBlockEntityRenderer.hasBindingAttempt(view, tile.m_58899_())) || tile.m_58899_().equals((Object)pos)) {
            SpecialFlowerBlockEntity flower = tile;
            ms.m_85836_();
            if (hasBindingAttempt) {
                ms.m_85837_(0.0, 0.005, 0.0);
            }
            SpecialFlowerBlockEntityRenderer.renderRadius(tile, ms, buffers, flower.getRadius());
            ms.m_85837_(0.0, 0.002, 0.0);
            SpecialFlowerBlockEntityRenderer.renderRadius(tile, ms, buffers, flower.getSecondaryRadius());
            ms.m_85849_();
        }
    }

    public static void renderRadius(BlockEntity tile, PoseStack ms, MultiBufferSource buffers, @Nullable RadiusDescriptor descriptor) {
        if (descriptor != null) {
            ms.m_85836_();
            ms.m_85837_(0.0, RenderHelper.getOffY(), 0.0);
            if (descriptor instanceof RadiusDescriptor.Circle) {
                RadiusDescriptor.Circle circle = (RadiusDescriptor.Circle)descriptor;
                SpecialFlowerBlockEntityRenderer.renderCircle(ms, buffers, tile.m_58899_(), circle.subtileCoords(), circle.radius());
            } else if (descriptor instanceof RadiusDescriptor.Rectangle) {
                RadiusDescriptor.Rectangle rectangle = (RadiusDescriptor.Rectangle)descriptor;
                SpecialFlowerBlockEntityRenderer.renderRectangle(ms, buffers, tile.m_58899_(), rectangle.aabb());
            }
            RenderHelper.incrementOffY();
            ms.m_85849_();
        }
    }

    public static boolean hasBindingAttempt(LivingEntity view, BlockPos tilePos) {
        ItemStack stackHeld = PlayerHelper.getFirstHeldItemClass(view, WandOfTheForestItem.class);
        if (!stackHeld.m_41619_() && WandOfTheForestItem.getBindMode(stackHeld)) {
            return WandOfTheForestItem.getBindingAttempt(stackHeld).filter(arg_0 -> ((BlockPos)tilePos).equals(arg_0)).isPresent();
        }
        return false;
    }

    public static void renderCircle(PoseStack ms, MultiBufferSource buffers, BlockPos tilePos, BlockPos center, double radius) {
        ms.m_85836_();
        ms.m_85837_((double)(center.m_123341_() - tilePos.m_123341_()) + 0.5, (double)(center.m_123342_() - tilePos.m_123342_()), (double)(center.m_123343_() - tilePos.m_123343_()) + 0.5);
        int color = Mth.m_14169_((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        VertexConsumer buffer = buffers.m_6299_(RenderHelper.CIRCLE);
        Matrix4f mat = ms.m_85850_().m_252922_();
        double innerRadius = radius - 0.0625;
        Runnable centerFuncInner = () -> buffer.m_252986_(mat, 0.0f, 0.0625f, 0.0f).m_6122_(r, g, b, 32).m_5752_();
        Runnable centerFuncOuter = () -> buffer.m_252986_(mat, 0.0f, 0.078125f, 0.0f).m_6122_(r, g, b, 64).m_5752_();
        Runnable[] vertexFuncsInner = new Runnable[361];
        Runnable[] vertexFuncsOuter = new Runnable[361];
        for (int i = 0; i < 360; ++i) {
            double rad = (double)(360 - i) * (Math.PI / 180);
            double cos = Math.cos(rad);
            double sin = Math.sin(rad);
            float xpInner = (float)(cos * innerRadius);
            float zpInner = (float)(sin * innerRadius);
            vertexFuncsInner[i] = () -> buffer.m_252986_(mat, xpInner, 0.0625f, zpInner).m_6122_(r, g, b, 32).m_5752_();
            float xpOuter = (float)(Math.cos(rad) * radius);
            float zpOuter = (float)(Math.sin(rad) * radius);
            vertexFuncsOuter[i] = () -> buffer.m_252986_(mat, xpOuter, 0.078125f, zpOuter).m_6122_(r, g, b, 64).m_5752_();
        }
        vertexFuncsInner[360] = vertexFuncsInner[0];
        vertexFuncsOuter[360] = vertexFuncsOuter[0];
        RenderHelper.triangleFan(centerFuncInner, vertexFuncsInner);
        RenderHelper.triangleFan(centerFuncOuter, vertexFuncsOuter);
        ms.m_85849_();
    }

    public static void renderRectangle(PoseStack ms, MultiBufferSource buffers, BlockPos tilePos, AABB aabb) {
        ms.m_85836_();
        ms.m_85837_(aabb.f_82288_ - (double)tilePos.m_123341_(), aabb.f_82289_ - (double)tilePos.m_123342_(), aabb.f_82290_ - (double)tilePos.m_123343_());
        int color = Mth.m_14169_((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float xSize = (float)aabb.m_82362_();
        float zSize = (float)aabb.m_82385_();
        float xSizeInner = xSize - 0.0625f;
        float zSizeInner = zSize - 0.0625f;
        VertexConsumer buffer = buffers.m_6299_(RenderHelper.RECTANGLE);
        Matrix4f mat = ms.m_85850_().m_252922_();
        RenderHelper.flatRectangle(buffer, mat, 0.0625f, xSizeInner, 0.0625f, 0.0625f, zSizeInner, r, g, b, 32);
        RenderHelper.flatRectangle(buffer, mat, 0.0f, xSize, 0.078125f, 0.0f, zSize, r, g, b, 64);
        ms.m_85849_();
    }
}

