/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.disk;

import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskFactory;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskManager;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.util.RSSavedData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;

public class StorageDiskManager
extends RSSavedData
implements IStorageDiskManager {
    public static final String NAME = "refinedstorage_disks";
    private static final String NBT_DISKS = "Disks";
    private static final String NBT_DISK_ID = "Id";
    private static final String NBT_DISK_TYPE = "Type";
    private static final String NBT_DISK_DATA = "Data";
    private final Map<UUID, IStorageDisk> disks = new HashMap<UUID, IStorageDisk>();
    private final ServerLevel level;

    public StorageDiskManager(ServerLevel level) {
        this.level = level;
    }

    @Override
    @Nullable
    public IStorageDisk get(UUID id) {
        return this.disks.get(id);
    }

    @Override
    @Nullable
    public IStorageDisk getByStack(ItemStack disk) {
        if (!(disk.m_41720_() instanceof IStorageDiskProvider)) {
            return null;
        }
        IStorageDiskProvider provider = (IStorageDiskProvider)disk.m_41720_();
        if (!provider.isValid(disk)) {
            return null;
        }
        return this.get(provider.getId(disk));
    }

    @Override
    public Map<UUID, IStorageDisk> getAll() {
        return this.disks;
    }

    @Override
    public void set(UUID id, IStorageDisk disk) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (disk == null) {
            throw new IllegalArgumentException("Disk cannot be null");
        }
        if (this.disks.containsKey(id)) {
            throw new IllegalArgumentException("Disks already contains id '" + id + "'");
        }
        this.disks.put(id, disk);
    }

    @Override
    public void remove(UUID id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        this.disks.remove(id);
    }

    @Override
    public void markForSaving() {
        this.m_77762_();
    }

    @Override
    public void load(CompoundTag tag) {
        if (tag.m_128441_(NBT_DISKS)) {
            ListTag disksTag = tag.m_128437_(NBT_DISKS, 10);
            for (int i = 0; i < disksTag.size(); ++i) {
                CompoundTag diskTag = disksTag.m_128728_(i);
                UUID id = diskTag.m_128342_(NBT_DISK_ID);
                CompoundTag data = diskTag.m_128469_(NBT_DISK_DATA);
                String type = diskTag.m_128461_(NBT_DISK_TYPE);
                IStorageDiskFactory factory = API.instance().getStorageDiskRegistry().get(new ResourceLocation(type));
                if (factory == null) continue;
                this.disks.put(id, factory.createFromNbt(this.level, data));
            }
        }
    }

    @Override
    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag disksTag = new ListTag();
        for (Map.Entry<UUID, IStorageDisk> entry : this.disks.entrySet()) {
            CompoundTag diskTag = new CompoundTag();
            diskTag.m_128362_(NBT_DISK_ID, entry.getKey());
            diskTag.m_128365_(NBT_DISK_DATA, (Tag)entry.getValue().writeToNbt());
            diskTag.m_128359_(NBT_DISK_TYPE, entry.getValue().getFactoryId().toString());
            disksTag.add((Object)diskTag);
        }
        tag.m_128365_(NBT_DISKS, (Tag)disksTag);
        return tag;
    }
}

