/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import java.util.ArrayList;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiPieMenu<T>
extends Screen {
    private static final ResourceLocation backgroundTex = new ResourceLocation("teamlapenlib", "textures/gui/pie_menu_bg.png");
    private static final ResourceLocation centerTex = new ResourceLocation("teamlapenlib", "textures/gui/pie_menu_center.png");
    private static final ResourceLocation WIDGETS = new ResourceLocation("textures/gui/widgets.png");
    private static final float BGT = 0.7f;
    private static final int BGS = 300;
    private static final int RR = 60;
    private static final int CS = 100;
    @NotNull
    protected final ArrayList<T> elements;
    protected final Color backgroundColor;
    private int selectedElement = -1;
    private int elementCount;
    private double radDiff;

    public GuiPieMenu(Color backgroundColorIn, @NotNull Component title) {
        super(title);
        this.backgroundColor = backgroundColorIn;
        this.elements = new ArrayList();
    }

    public void m_7856_() {
        this.onGuiInit();
        this.elementCount = this.elements.size();
        this.radDiff = Math.PI * 2 / (double)this.elementCount;
        GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212994);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7920_(int key, int scancode, int modifiers) {
        if (!this.isKeyBindingStillPressed()) {
            this.selectedAndClose();
            return true;
        }
        return false;
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (!this.isKeyBindingStillPressed()) {
            this.selectedAndClose();
            return true;
        }
        return false;
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        return false;
    }

    public void m_7861_() {
        super.m_7861_();
        GLFW.glfwSetInputMode((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)208897, (int)212993);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean center;
        int cX = this.f_96543_ / 2;
        int cY = this.f_96544_ / 2;
        double radius = (double)this.f_96544_ / 4.0;
        this.drawBackground(graphics, cX, cY);
        double mouseRad = this.updateMouse(mouseX, mouseY, cX, cY, radius / 2.0);
        boolean bl = center = (double)((mouseX - cX) * (mouseX - cX) + (mouseY - cY) * (mouseY - cY)) < radius / 4.0 * (radius / 4.0);
        if (center) {
            this.selectedElement = -1;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            T element = this.elements.get(i);
            double rad = this.radDiff * (double)i;
            boolean selected = false;
            if (!center && mouseRad > rad - this.radDiff / 2.0 && mouseRad < rad + this.radDiff / 2.0) {
                selected = true;
            } else if (!center && rad == 0.0 && mouseRad > Math.PI * 2 - this.radDiff / 2.0) {
                selected = true;
            }
            int x = (int)((double)cX + Math.cos(rad) * radius) - 8;
            int y = (int)((double)cY - Math.sin(rad) * radius) - 8;
            Color col = this.getColor(element);
            RenderSystem.enableBlend();
            graphics.m_280246_((float)col.getRed(), (float)col.getGreen(), (float)col.getBlue(), 0.5f);
            graphics.m_280218_(WIDGETS, x - 2, y - 2, 1, 1, 20, 20);
            if (selected) {
                graphics.m_280218_(WIDGETS, x - 3, y - 3, 1, 23, 22, 22);
            }
            if (selected) {
                this.selectedElement = i;
                this.drawSelectedCenter(graphics, cX, cY, rad);
            }
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getIconLoc(element));
            UtilLib.drawTexturedModalRect(graphics.m_280168_().m_85850_().m_252922_(), 0.0f, x, y, 0, 0, 16, 16, 16, 16);
            this.afterIconDraw(graphics, element, x, y);
        }
        if (this.selectedElement == -1) {
            this.drawUnselectedCenter(graphics, cX, cY);
        } else {
            Component name = this.getName(this.elements.get(this.selectedElement));
            int tx = cX - this.f_96541_.f_91062_.m_92852_((FormattedText)name) / 2;
            int ty = this.f_96544_ / 7;
            graphics.m_280614_(this.f_96541_.f_91062_, name, tx, ty, Color.WHITE.getRGB(), true);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            if (!this.f_96541_.f_91074_.m_6084_()) {
                this.f_96541_.f_91074_.m_6915_();
            } else {
                float f = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)this.f_96541_.f_91074_)), (float)0.0f, (float)1.0f);
                this.f_96541_.f_91074_.f_108618_.m_214106_(this.f_96541_.f_91074_.m_108635_(), f);
            }
        }
    }

    protected void afterIconDraw(GuiGraphics graphics, T element, int x, int y) {
    }

    protected void drawLine(@NotNull GuiGraphics graphics, double x1, double y1, double x2, double y2) {
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_85815_);
        RenderSystem.lineWidth((float)2.0f);
        builder.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)x1, (float)y1, 0.0f).m_6122_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).m_5752_();
        builder.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)x2, (float)y2, 0.0f).m_6122_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    @NotNull
    protected Color getColor(T s) {
        return Color.WHITE;
    }

    protected abstract ResourceLocation getIconLoc(T var1);

    protected abstract KeyMapping getMenuKeyBinding();

    protected abstract Component getName(T var1);

    protected int getSelectedElement() {
        return this.selectedElement;
    }

    protected boolean isKeyBindingStillPressed() {
        return this.getMenuKeyBinding().m_90857_();
    }

    protected void onElementSelected(T id) {
    }

    protected abstract void onGuiInit();

    protected void selectedAndClose() {
        this.m_7379_();
        if (this.selectedElement >= 0) {
            this.onElementSelected(this.elements.get(this.selectedElement));
        }
    }

    private void drawBackground(@NotNull GuiGraphics graphics, float cX, float cY) {
        PoseStack pose = graphics.m_280168_();
        float scale = ((float)this.f_96544_ / 2.0f + 16.0f + 16.0f) / 300.0f;
        pose.m_85836_();
        RenderSystem.enableBlend();
        pose.m_252880_(cX, cY, 0.0f);
        pose.m_85841_(scale, scale, 1.0f);
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)backgroundTex);
        Matrix4f matrix = pose.m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        builder.m_252986_(matrix, 150.0f, 150.0f, 0.0f).m_6122_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).m_7421_(1.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix, 150.0f, -150.0f, 0.0f).m_6122_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).m_7421_(1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, -150.0f, -150.0f, 0.0f).m_6122_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).m_7421_(0.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, -150.0f, 150.0f, 0.0f).m_6122_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).m_7421_(0.0f, 1.0f).m_5752_();
        tesselator.m_85914_();
        if (this.elementCount > 1) {
            for (int i = 0; i < this.elementCount; ++i) {
                double rad = (double)i * this.radDiff + this.radDiff / 2.0;
                double cos = Math.cos(rad);
                double sin = Math.sin(rad);
                this.drawLine(graphics, cos * 60.0, sin * 60.0, cos * 300.0 / 2.0, sin * 300.0 / 2.0);
            }
        }
        RenderSystem.disableBlend();
        pose.m_85849_();
    }

    private void drawSelectedCenter(@NotNull GuiGraphics graphics, double cX, double cY, double rad) {
        PoseStack pose = graphics.m_280168_();
        double deg = Math.toDegrees(-rad);
        float scale = (float)this.f_96544_ / 4.0f / 100.0f;
        pose.m_85836_();
        RenderSystem.enableBlend();
        pose.m_85837_(cX, cY, 0.0);
        pose.m_85841_(scale, scale, 1.0f);
        pose.m_252781_(Axis.f_252403_.m_252977_((float)deg));
        Matrix4f matrix = pose.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)centerTex);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        builder.m_252986_(matrix, 50.0f, 50.0f, 0.0f).m_6122_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).m_7421_(0.5f, 1.0f).m_5752_();
        builder.m_252986_(matrix, 50.0f, -50.0f, 0.0f).m_6122_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).m_7421_(0.5f, 0.0f).m_5752_();
        builder.m_252986_(matrix, -50.0f, -50.0f, 0.0f).m_6122_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).m_7421_(0.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, -50.0f, 50.0f, 0.0f).m_6122_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).m_7421_(0.0f, 1.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        pose.m_85849_();
    }

    private void drawUnselectedCenter(@NotNull GuiGraphics graphics, double cX, double cY) {
        PoseStack pose = graphics.m_280168_();
        float scale = (float)this.f_96544_ / 4.0f / 100.0f;
        pose.m_85836_();
        RenderSystem.enableBlend();
        pose.m_85837_(cX, cY, 0.0);
        pose.m_85841_(scale, scale, 1.0f);
        Matrix4f matrix = pose.m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)centerTex);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        builder.m_252986_(matrix, 50.0f, 50.0f, 0.0f).m_6122_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).m_7421_(1.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix, 50.0f, -50.0f, 0.0f).m_6122_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).m_7421_(1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix, -50.0f, -50.0f, 0.0f).m_6122_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).m_7421_(0.5f, 0.0f).m_5752_();
        builder.m_252986_(matrix, -50.0f, 50.0f, 0.0f).m_6122_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).m_7421_(0.5f, 1.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        pose.m_85849_();
    }

    private void setAbsoluteMouse(double x, double y) {
        x = x * (double)this.f_96541_.m_91268_().m_85441_() / (double)this.f_96543_;
        y = -(y + 1.0 - (double)this.f_96544_) * (double)this.f_96541_.m_91268_().m_85442_() / (double)this.f_96544_;
        GLFW.glfwSetCursorPos((long)this.f_96541_.m_91268_().m_85439_(), (double)x, (double)y);
    }

    private double updateMouse(int x, int y, int cX, int cY, double r) {
        int dx = x - cX;
        int dy = y - cY;
        double rad = Math.atan2(dy, -dx) + Math.PI;
        if ((double)Math.abs(dx) > Math.abs(Math.cos(rad) * r) + 8.0 || (double)Math.abs(dy) > Math.abs(Math.sin(rad) * r) + 8.0) {
            this.setAbsoluteMouse((double)dx / 1.5 + (double)cX + 4.0, (double)cY - (double)dy / 1.5);
        }
        return rad;
    }
}

