/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.blockentity.InventoryBlockEntity;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.general.BloodConversionRegistry;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.inventory.BloodGrinderMenu;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BloodGrinderBlockEntity
extends InventoryBlockEntity {
    @NotNull
    private final IItemHandler itemHandler = this.createWrapper();
    @NotNull
    private final LazyOptional<IItemHandler> itemHandlerOptional = LazyOptional.of(() -> this.itemHandler);
    private int cooldownPull = 0;
    private int cooldownProcess = 0;

    @NotNull
    private static List<ItemEntity> getCaptureItems(@NotNull Level worldIn, @NotNull BlockPos pos) {
        int posX = pos.m_123341_();
        int posY = pos.m_123342_();
        int posZ = pos.m_123343_();
        return worldIn.m_6443_(ItemEntity.class, new AABB((double)posX, (double)posY + 0.5, (double)posZ, (double)posX + 1.0, (double)posY + 1.5, (double)posZ + 1.0), EntitySelector.f_20402_);
    }

    public BloodGrinderBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.GRINDER.get(), pos, state, 1, BloodGrinderMenu.SELECTOR_INFOS);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side != Direction.DOWN && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.cooldownPull = tagCompound.m_128451_("cooldown_pull");
        this.cooldownProcess = tagCompound.m_128451_("cooldown_process");
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("cooldown_pull", this.cooldownPull);
        compound.m_128405_("cooldown_process", this.cooldownProcess);
    }

    public static void serverTick(@NotNull Level level, @NotNull BlockPos pos, BlockState state, @NotNull BloodGrinderBlockEntity blockEntity) {
        --blockEntity.cooldownPull;
        if (blockEntity.cooldownPull <= 0) {
            boolean flag;
            blockEntity.cooldownPull = 10;
            if (!blockEntity.isFull() && (flag = BloodGrinderBlockEntity.pullItems(blockEntity, level, pos))) {
                blockEntity.cooldownPull = 20;
            }
        }
        --blockEntity.cooldownProcess;
        if (blockEntity.cooldownProcess <= 0) {
            blockEntity.cooldownProcess = 10;
            blockEntity.updateProcess();
        }
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int id, @NotNull Inventory player) {
        return new BloodGrinderMenu(id, player, (Container)this, ContainerLevelAccess.m_39289_((Level)player.f_35978_.m_20193_(), (BlockPos)this.m_58899_()));
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"tile.vampirism.blood_grinder");
    }

    private static boolean pullItems(@NotNull BloodGrinderBlockEntity blockEntity, @NotNull Level level, @NotNull BlockPos pos) {
        boolean flag = InventoryHelper.tryGetItemHandler((BlockGetter)level, pos.m_7494_(), Direction.DOWN).map(pair -> {
            IItemHandler handler = (IItemHandler)pair.getLeft();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack simulated;
                ItemStack extracted = handler.extractItem(i, 1, true);
                if (extracted.m_41619_() || !(simulated = ItemHandlerHelper.insertItemStacked((IItemHandler)blockEntity.itemHandler, (ItemStack)extracted, (boolean)true)).m_41619_()) continue;
                extracted = handler.extractItem(i, 1, false);
                ItemHandlerHelper.insertItemStacked((IItemHandler)blockEntity.itemHandler, (ItemStack)extracted, (boolean)false);
                return true;
            }
            return false;
        }).orElse(false);
        if (flag) {
            return true;
        }
        for (ItemEntity entityItem : BloodGrinderBlockEntity.getCaptureItems(level, pos)) {
            ItemStack stack = entityItem.m_32055_();
            for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
                ItemStack stack2 = blockEntity.itemHandler.insertItem(i, stack, true);
                if (!stack2.m_41619_()) continue;
                stack2 = blockEntity.itemHandler.insertItem(i, stack, false);
                if (stack2.m_41613_() < stack.m_41613_()) {
                    entityItem.m_146870_();
                } else {
                    entityItem.m_32045_(stack2);
                }
                return true;
            }
        }
        return false;
    }

    private void updateProcess() {
        if (this.f_58857_ != null && !this.m_7983_()) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                int slot = i;
                ItemStack stack = this.itemHandler.extractItem(i, 1, true);
                int blood = BloodConversionRegistry.getImpureBloodValue(stack.m_41720_());
                if (blood <= 0) continue;
                FluidStack fluid = new FluidStack((Fluid)ModFluids.IMPURE_BLOOD.get(), blood);
                FluidUtil.getFluidHandler((Level)this.f_58857_, (BlockPos)this.f_58858_.m_7495_(), (Direction)Direction.UP).ifPresent(handler -> {
                    int filled = handler.fill(fluid, IFluidHandler.FluidAction.SIMULATE);
                    if ((float)filled >= 0.9f * (float)blood) {
                        ItemStack extractedStack = this.itemHandler.extractItem(slot, 1, false);
                        handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.GRINDER.get(), SoundSource.BLOCKS, 0.5f, 0.7f);
                        this.cooldownProcess = Mth.m_14045_((int)(20 * filled / 100), (int)20, (int)100);
                    }
                });
            }
        }
    }
}

