/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks.mother;

import de.teamlapen.vampirism.blockentity.MotherBlockEntity;
import de.teamlapen.vampirism.blocks.CursedEarthBlock;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import de.teamlapen.vampirism.blocks.mother.ActiveVulnerableRemainsBlock;
import de.teamlapen.vampirism.blocks.mother.IRemainsBlock;
import de.teamlapen.vampirism.blocks.mother.MotherTreeStructure;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HangingRootsBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class RemainsBlock
extends VampirismBlock
implements BonemealableBlock,
IRemainsBlock {
    private final boolean vulnerable;
    private final boolean isVulnerability;

    public RemainsBlock(BlockBehaviour.Properties properties, boolean vulnerable, boolean isVulnerability) {
        super(properties);
        this.vulnerable = vulnerable;
        this.isVulnerability = isVulnerability;
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, @NotNull BlockState pState, boolean pIsClient) {
        return pLevel.m_8055_(pPos.m_7495_()).m_60795_();
    }

    public boolean m_214167_(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    @Override
    public boolean isVulnerable(BlockState state) {
        return this.vulnerable;
    }

    @Override
    public boolean isMother(BlockState state) {
        return false;
    }

    @Override
    public boolean isVulnerability(BlockState state) {
        return this.isVulnerability;
    }

    public void m_214148_(ServerLevel level, @NotNull RandomSource random, BlockPos pos, @NotNull BlockState state) {
        level.m_46597_(pos.m_7495_(), ((HangingRootsBlock)ModBlocks.CURSED_HANGING_ROOTS.get()).m_49966_());
    }

    public void m_6256_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.getMotherEntity((LevelAccessor)level, pos).ifPresent(a -> a.informAboutAttacker(serverPlayer));
        }
        DamageHandler.hurtModded((Entity)player, ModDamageSources::mother, 1.0f);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.getMotherEntity((LevelAccessor)level, pos).ifPresent(MotherBlockEntity::onStructureBlockRemoved);
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (random.m_188503_(100) == 0) {
            if (MotherTreeStructure.findMother((LevelAccessor)level, pos).isEmpty()) {
                level.m_46597_(pos, ((CursedEarthBlock)ModBlocks.CURSED_EARTH.get()).m_49966_());
            }
            if (state.m_204336_(ModTags.Blocks.VULNERABLE_REMAINS) && Arrays.stream(Direction.values()).allMatch(d -> level.m_8055_(pos.m_121945_(d)).m_204336_(ModTags.Blocks.REMAINS))) {
                level.m_46597_(pos, ((CursedEarthBlock)ModBlocks.CURSED_EARTH.get()).m_49966_());
            }
        }
    }

    @Override
    public void unFreeze(Level level, BlockPos pos, BlockState state) {
        if (this == ModBlocks.VULNERABLE_REMAINS.get()) {
            level.m_7731_(pos, ((ActiveVulnerableRemainsBlock)ModBlocks.ACTIVE_VULNERABLE_REMAINS.get()).m_49966_(), 3);
        }
    }

    private Optional<MotherBlockEntity> getMotherEntity(@NotNull LevelAccessor level, @NotNull BlockPos pos) {
        return MotherTreeStructure.findMother(level, pos).map(pair -> {
            BlockEntity blockEntity = level.m_7702_((BlockPos)pair.getLeft());
            if (blockEntity instanceof MotherBlockEntity) {
                MotherBlockEntity mother = (MotherBlockEntity)blockEntity;
                return mother;
            }
            return null;
        });
    }
}

