/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.mojang.serialization.Codec;
import de.teamlapen.vampirism.particle.FlyingBloodEntityParticleOptions;
import de.teamlapen.vampirism.particle.FlyingBloodParticleOptions;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModParticles {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"vampirism");
    public static final RegistryObject<ParticleType<FlyingBloodParticleOptions>> FLYING_BLOOD = PARTICLE_TYPES.register("flying_blood", () -> new ParticleType<FlyingBloodParticleOptions>(false, FlyingBloodParticleOptions.DESERIALIZER){

        @NotNull
        public Codec<FlyingBloodParticleOptions> m_7652_() {
            return FlyingBloodParticleOptions.CODEC;
        }
    });
    public static final RegistryObject<ParticleType<FlyingBloodEntityParticleOptions>> FLYING_BLOOD_ENTITY = PARTICLE_TYPES.register("flying_blood_entity", () -> new ParticleType<FlyingBloodEntityParticleOptions>(false, FlyingBloodEntityParticleOptions.DESERIALIZER){

        @NotNull
        public Codec<FlyingBloodEntityParticleOptions> m_7652_() {
            return FlyingBloodEntityParticleOptions.CODEC;
        }
    });
    public static final RegistryObject<ParticleType<GenericParticleOptions>> GENERIC = PARTICLE_TYPES.register("generic", () -> new ParticleType<GenericParticleOptions>(false, GenericParticleOptions.DESERIALIZER){

        @NotNull
        public Codec<GenericParticleOptions> m_7652_() {
            return GenericParticleOptions.CODEC;
        }
    });

    static void register(IEventBus bus) {
        PARTICLE_TYPES.register(bus);
    }

    public static void spawnParticlesClient(Level worldIn, @NotNull ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int count, double maxDist, @NotNull RandomSource rand) {
        assert (!(worldIn instanceof ServerLevel)) : "Calling spawnParticlesClient on ServerWorld is pointless";
        for (int i = 0; i < count; ++i) {
            worldIn.m_7106_(particle, x + maxDist * (2.0 * rand.m_188500_() - 1.0), y + (2.0 * rand.m_188500_() - 1.0) * maxDist, z + (2.0 * rand.m_188500_() - 1.0) * maxDist, xSpeed, ySpeed, zSpeed);
        }
    }

    public static void spawnParticlesClient(Level worldIn, @NotNull ParticleOptions particle, double x, double y, double z, int count, double maxDist, @NotNull RandomSource rand) {
        ModParticles.spawnParticlesClient(worldIn, particle, x, y, z, 0.0, 0.0, 0.0, count, maxDist, rand);
    }

    public static void spawnParticleClient(@NotNull Level worldIn, @NotNull ParticleOptions particle, double x, double y, double z) {
        ModParticles.spawnParticleClient(worldIn, particle, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void spawnParticleClient(@NotNull Level worldIn, @NotNull ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        assert (!(worldIn instanceof ServerLevel)) : "Calling spawnParticleClient on ServerWorld is pointless";
        worldIn.m_7106_(particle, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public static int spawnParticlesServer(Level worldIn, @NotNull ParticleOptions particle, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        assert (worldIn instanceof ServerLevel) : "Calling spawnParticlesServer on client side is pointless";
        if (worldIn instanceof ServerLevel) {
            return ((ServerLevel)worldIn).m_8767_(particle, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed);
        }
        return 0;
    }
}

