/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public record ServerboundDeleteRefinementPacket(IRefinementItem.AccessorySlotType slot) implements IMessage.IServerBoundMessage
{
    static void encode(@NotNull ServerboundDeleteRefinementPacket msg, @NotNull FriendlyByteBuf buf) {
        buf.m_130068_((Enum)msg.slot);
    }

    @NotNull
    static ServerboundDeleteRefinementPacket decode(@NotNull FriendlyByteBuf buf) {
        return new ServerboundDeleteRefinementPacket((IRefinementItem.AccessorySlotType)buf.m_130066_(IRefinementItem.AccessorySlotType.class));
    }

    static void handle(@NotNull ServerboundDeleteRefinementPacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayer player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            Optional factionPlayerOpt = FactionPlayerHandler.getOpt((Player)player).map(FactionPlayerHandler::getCurrentFactionPlayer).orElseGet(Optional::empty);
            factionPlayerOpt.ifPresent(fp -> fp.getSkillHandler().removeRefinementItem(msg.slot));
        });
        ctx.setPacketHandled(true);
    }
}

