/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.backup;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.handler.PresetHandler;
import de.markusbordihn.easynpc.io.BackupDataFiles;
import java.io.File;
import java.nio.file.Path;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected static final String LOG_PREFIX = "[Backup Manager]";
    private static final ConcurrentHashMap<UUID, Long> lastNPCBackupTime = new ConcurrentHashMap();
    private static final long BACKUP_INTERVAL = 3600000L;
    private static final long BACKUP_TICK = 1200L;
    private static long lastBackupTime = 0L;
    private static long backupTicks = 0L;

    public static void performBackup() {
        if (backupTicks++ < 1200L) {
            return;
        }
        if (BackupManager.shouldPerformBackup()) {
            long backupTime = System.currentTimeMillis();
            BackupManager.backupNPCData();
            lastBackupTime = backupTime;
        }
        backupTicks = 0L;
    }

    private static boolean shouldPerformBackup() {
        return lastBackupTime == 0L || System.currentTimeMillis() - lastBackupTime > 3600000L;
    }

    private static void backupNPCData() {
        Date currentDate = new Date();
        LivingEntityManager.getNpcEntityMap().forEach((uuid, easyNPC) -> {
            Path backupFilePath;
            if (uuid == null || easyNPC == null) {
                return;
            }
            if (lastNPCBackupTime.containsKey(uuid)) {
                long lastBackup = lastNPCBackupTime.get(uuid);
                if (System.currentTimeMillis() - lastBackup < 3600000L) {
                    log.debug("{} [Skipping] Backup for {} already done in the last hour.", (Object)LOG_PREFIX, easyNPC);
                    return;
                }
            }
            if ((backupFilePath = BackupDataFiles.getBackupFile(uuid, currentDate)) == null) {
                log.warn("{} [Error] Backup file path for {} is null.", (Object)LOG_PREFIX, easyNPC);
                return;
            }
            File backupFile = backupFilePath.toFile();
            if (backupFile.exists()) {
                log.debug("{} [Overwrite] Backup file {} for {} ...", (Object)LOG_PREFIX, (Object)backupFile, easyNPC);
            } else {
                log.debug("{} [Create] Backup file {} for {} ...", (Object)LOG_PREFIX, (Object)backupFile, easyNPC);
            }
            PresetHandler.exportPreset(easyNPC, backupFile);
        });
    }
}

