/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import java.util.Objects;
import java.util.UUID;

public class TextureModelKey {
    private final UUID uuid;
    private final String subType;
    private final SkinModel skinModel;
    private final String resourceName;

    public TextureModelKey(UUID uuid, SkinModel skinModel) {
        this(uuid, skinModel, "");
    }

    public TextureModelKey(UUID uuid, SkinModel skinModel, String resourceName) {
        this.uuid = uuid;
        this.subType = skinModel != null ? skinModel.name() : "";
        this.skinModel = skinModel;
        this.resourceName = resourceName != null ? resourceName : "";
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getSubType() {
        return this.subType;
    }

    public SkinModel getSkinModel() {
        return this.skinModel;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.subType);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TextureModelKey)) {
            return false;
        }
        TextureModelKey textureModelKey = (TextureModelKey)object;
        return this.uuid.equals(textureModelKey.uuid) && this.subType.equals(textureModelKey.subType);
    }

    public String toString() {
        return "TextureModelKey{uuid=" + this.uuid + ", skinModel=" + this.skinModel + ", subType='" + this.subType + ", resourceName='" + this.resourceName + "'}";
    }
}

