/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.sound;

import de.markusbordihn.easynpc.data.sound.SoundDataEntry;
import de.markusbordihn.easynpc.data.sound.SoundType;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class SoundDataSet {
    public static final String DATA_SOUND_DATA_SET_TAG = "SoundDataSet";
    private final Map<SoundType, SoundDataEntry> soundDataEntryMap = new EnumMap<SoundType, SoundDataEntry>(SoundType.class);

    public SoundDataSet() {
    }

    public SoundDataSet(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public boolean hasSound(SoundType type) {
        return this.soundDataEntryMap.containsKey((Object)type);
    }

    public void addSound(SoundType type, SoundEvent soundEvent) {
        this.addSound(type, soundEvent.m_11660_());
    }

    public void addSound(SoundType type, ResourceLocation resourceLocation) {
        this.soundDataEntryMap.put(type, new SoundDataEntry(type, resourceLocation));
    }

    public boolean isEmpty() {
        return this.soundDataEntryMap.isEmpty();
    }

    public SoundDataEntry getSound(SoundType type) {
        return this.soundDataEntryMap.get((Object)type);
    }

    public void load(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(DATA_SOUND_DATA_SET_TAG)) {
            return;
        }
        this.soundDataEntryMap.clear();
        ListTag soundListTag = compoundTag.m_128437_(DATA_SOUND_DATA_SET_TAG, 10);
        for (int i = 0; i < soundListTag.size(); ++i) {
            CompoundTag soundDataTag = soundListTag.m_128728_(i);
            SoundDataEntry soundDataEntry = new SoundDataEntry(soundDataTag);
            this.soundDataEntryMap.put(soundDataEntry.getType(), soundDataEntry);
        }
    }

    public CompoundTag save(CompoundTag compoundTag) {
        ListTag soundListTag = new ListTag();
        for (Map.Entry<SoundType, SoundDataEntry> entry : this.soundDataEntryMap.entrySet()) {
            SoundDataEntry soundDataEntry = entry.getValue();
            soundListTag.add((Object)soundDataEntry.createTag());
        }
        compoundTag.m_128365_(DATA_SOUND_DATA_SET_TAG, (Tag)soundListTag);
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.save(new CompoundTag());
    }
}

