/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface ModelRotationData<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final CustomRotation DEFAULT_MODEL_PART_ROTATION = new CustomRotation(0.0f, 0.0f, 0.0f);
    public static final String EASY_NPC_DATA_MODEL_LOCK_TAG = "Lock";
    public static final String EASY_NPC_DATA_MODEL_ROTATION_TAG = "Rotation";

    public static void registerSyncedModelRotationData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Model Rotation Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_LOCK_ROTATION, SynchedEntityData.m_135353_(entityClass, (EntityDataSerializer)EntityDataSerializers.f_135035_));
        map.put(SynchedDataIndex.MODEL_HEAD_ROTATION, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.ROTATION));
        map.put(SynchedDataIndex.MODEL_BODY_ROTATION, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.ROTATION));
        map.put(SynchedDataIndex.MODEL_ARMS_ROTATION, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.ROTATION));
        map.put(SynchedDataIndex.MODEL_LEFT_ARM_ROTATION, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.ROTATION));
        map.put(SynchedDataIndex.MODEL_RIGHT_ARM_ROTATION, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.ROTATION));
        map.put(SynchedDataIndex.MODEL_LEFT_LEG_ROTATION, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.ROTATION));
        map.put(SynchedDataIndex.MODEL_RIGHT_LEG_ROTATION, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.ROTATION));
        map.put(SynchedDataIndex.MODEL_ROOT_ROTATION, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.ROTATION));
    }

    public boolean hasHeadModelPart();

    public boolean hasBodyModelPart();

    public boolean hasArmsModelPart();

    public boolean hasLeftArmModelPart();

    public boolean hasRightArmModelPart();

    public boolean hasLeftLegModelPart();

    public boolean hasRightLegModelPart();

    default public CustomRotation getModelPartRotation(ModelPart modelPart) {
        return switch (modelPart) {
            case ModelPart.HEAD -> this.getModelHeadRotation();
            case ModelPart.BODY -> this.getModelBodyRotation();
            case ModelPart.ARMS -> this.getModelArmsRotation();
            case ModelPart.LEFT_ARM -> this.getModelLeftArmRotation();
            case ModelPart.RIGHT_ARM -> this.getModelRightArmRotation();
            case ModelPart.LEFT_LEG -> this.getModelLeftLegRotation();
            case ModelPart.RIGHT_LEG -> this.getModelRightLegRotation();
            default -> DEFAULT_MODEL_PART_ROTATION;
        };
    }

    default public void setModelPartRotation(ModelPart modelPart, CustomRotation rotation) {
        switch (modelPart) {
            case HEAD: {
                this.setModelHeadRotation(rotation);
                break;
            }
            case BODY: {
                this.setModelBodyRotation(rotation);
                break;
            }
            case ARMS: {
                this.setModelArmsRotation(rotation);
                break;
            }
            case LEFT_ARM: {
                this.setModelLeftArmRotation(rotation);
                break;
            }
            case RIGHT_ARM: {
                this.setModelRightArmRotation(rotation);
                break;
            }
            case LEFT_LEG: {
                this.setModelLeftLegRotation(rotation);
                break;
            }
            case RIGHT_LEG: {
                this.setModelRightLegRotation(rotation);
                break;
            }
            case ROOT: {
                this.setModelRootRotation(rotation);
                break;
            }
            default: {
                log.error("Invalid rotation model part {} for {}", (Object)modelPart, (Object)this);
            }
        }
    }

    default public boolean hasChangedModelRotation() {
        return this.hasHeadModelPart() && this.getModelHeadRotation().hasChanged() || this.hasBodyModelPart() && this.getModelBodyRotation().hasChanged() || this.hasArmsModelPart() && this.getModelArmsRotation().hasChanged() || this.hasLeftArmModelPart() && this.getModelLeftArmRotation().hasChanged() || this.hasRightArmModelPart() && this.getModelRightArmRotation().hasChanged() || this.hasLeftLegModelPart() && this.getModelLeftLegRotation().hasChanged() || this.hasRightLegModelPart() && this.getModelRightLegRotation().hasChanged();
    }

    default public boolean getModelLockRotation() {
        return (Boolean)this.getSynchedEntityData(SynchedDataIndex.MODEL_LOCK_ROTATION);
    }

    default public void setModelLockRotation(boolean modelLockRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LOCK_ROTATION, modelLockRotation);
    }

    default public CustomRotation getModelHeadRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_HEAD_ROTATION);
    }

    default public void setModelHeadRotation(CustomRotation modelHeadRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_HEAD_ROTATION, modelHeadRotation);
    }

    default public CustomRotation getModelBodyRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_BODY_ROTATION);
    }

    default public void setModelBodyRotation(CustomRotation modelBodyRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_BODY_ROTATION, modelBodyRotation);
    }

    default public CustomRotation getModelArmsRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_ARMS_ROTATION);
    }

    default public void setModelArmsRotation(CustomRotation modelArmsRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_ARMS_ROTATION, modelArmsRotation);
    }

    default public CustomRotation getModelLeftArmRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_ROTATION);
    }

    default public void setModelLeftArmRotation(CustomRotation modelLeftArmRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_ROTATION, modelLeftArmRotation);
    }

    default public CustomRotation getModelRightArmRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_ROTATION);
    }

    default public void setModelRightArmRotation(CustomRotation modelRightArmRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_ROTATION, modelRightArmRotation);
    }

    default public CustomRotation getModelLeftLegRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_ROTATION);
    }

    default public void setModelLeftLegRotation(CustomRotation modelLeftLegRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_ROTATION, modelLeftLegRotation);
    }

    default public CustomRotation getModelRightLegRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_ROTATION);
    }

    default public void setModelRightLegRotation(CustomRotation modelRightLegRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_ROTATION, modelRightLegRotation);
    }

    default public CustomRotation getModelRootRotation() {
        return (CustomRotation)this.getSynchedEntityData(SynchedDataIndex.MODEL_ROOT_ROTATION);
    }

    default public void setModelRootRotation(CustomRotation modelRootRotation) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_ROOT_ROTATION, modelRootRotation);
    }

    default public void defineSynchedModelRotationData() {
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_LOCK_ROTATION, false);
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_HEAD_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_BODY_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_ARMS_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_LEFT_ARM_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_ARM_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_LEFT_LEG_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_RIGHT_LEG_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_ROOT_ROTATION, new CustomRotation(0.0f, 0.0f, 0.0f));
    }

    default public void addAdditionalModelRotationData(CompoundTag compoundTag) {
        CompoundTag rotationsTag = new CompoundTag();
        if (this.getModelLockRotation()) {
            rotationsTag.m_128379_(EASY_NPC_DATA_MODEL_LOCK_TAG, this.getModelLockRotation());
        }
        if (this.hasHeadModelPart() && this.getModelHeadRotation() != null && this.getModelHeadRotation().hasChanged()) {
            rotationsTag.m_128365_(ModelPart.HEAD.getTagName(), (Tag)this.getModelHeadRotation().save());
        }
        if (this.hasBodyModelPart() && this.getModelBodyRotation() != null && this.getModelBodyRotation().hasChanged()) {
            rotationsTag.m_128365_(ModelPart.BODY.getTagName(), (Tag)this.getModelBodyRotation().save());
        }
        if (this.hasArmsModelPart() && this.getModelArmsRotation() != null && this.getModelArmsRotation().hasChanged()) {
            rotationsTag.m_128365_(ModelPart.ARMS.getTagName(), (Tag)this.getModelArmsRotation().save());
        }
        if (this.hasLeftArmModelPart() && this.getModelLeftArmRotation() != null && this.getModelLeftArmRotation().hasChanged()) {
            rotationsTag.m_128365_(ModelPart.LEFT_ARM.getTagName(), (Tag)this.getModelLeftArmRotation().save());
        }
        if (this.hasRightArmModelPart() && this.getModelRightArmRotation() != null && this.getModelRightArmRotation().hasChanged()) {
            rotationsTag.m_128365_(ModelPart.RIGHT_ARM.getTagName(), (Tag)this.getModelRightArmRotation().save());
        }
        if (this.hasLeftLegModelPart() && this.getModelLeftLegRotation() != null && this.getModelLeftLegRotation().hasChanged()) {
            rotationsTag.m_128365_(ModelPart.LEFT_LEG.getTagName(), (Tag)this.getModelLeftLegRotation().save());
        }
        if (this.hasRightLegModelPart() && this.getModelRightLegRotation() != null && this.getModelRightLegRotation().hasChanged()) {
            rotationsTag.m_128365_(ModelPart.RIGHT_LEG.getTagName(), (Tag)this.getModelRightLegRotation().save());
        }
        if (this.getModelRootRotation() != null && this.getModelRootRotation().hasChanged()) {
            rotationsTag.m_128365_(ModelPart.ROOT.getTagName(), (Tag)this.getModelRootRotation().save());
        }
        compoundTag.m_128365_(EASY_NPC_DATA_MODEL_ROTATION_TAG, (Tag)rotationsTag);
    }

    default public void readAdditionalModelRotationData(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(EASY_NPC_DATA_MODEL_ROTATION_TAG)) {
            return;
        }
        CompoundTag rotationsTag = compoundTag.m_128469_(EASY_NPC_DATA_MODEL_ROTATION_TAG);
        if (rotationsTag.m_128441_(EASY_NPC_DATA_MODEL_LOCK_TAG)) {
            this.setModelLockRotation(rotationsTag.m_128471_(EASY_NPC_DATA_MODEL_LOCK_TAG));
        }
        if (rotationsTag.m_128441_(ModelPart.HEAD.getTagName())) {
            this.setModelHeadRotation(new CustomRotation(rotationsTag.m_128437_(ModelPart.HEAD.getTagName(), 5)));
        }
        if (rotationsTag.m_128441_(ModelPart.BODY.getTagName())) {
            this.setModelBodyRotation(new CustomRotation(rotationsTag.m_128437_(ModelPart.BODY.getTagName(), 5)));
        }
        if (rotationsTag.m_128441_(ModelPart.ARMS.getTagName())) {
            this.setModelArmsRotation(new CustomRotation(rotationsTag.m_128437_(ModelPart.ARMS.getTagName(), 5)));
        }
        if (rotationsTag.m_128441_(ModelPart.LEFT_ARM.getTagName())) {
            this.setModelLeftArmRotation(new CustomRotation(rotationsTag.m_128437_(ModelPart.LEFT_ARM.getTagName(), 5)));
        }
        if (rotationsTag.m_128441_(ModelPart.RIGHT_ARM.getTagName())) {
            this.setModelRightArmRotation(new CustomRotation(rotationsTag.m_128437_(ModelPart.RIGHT_ARM.getTagName(), 5)));
        }
        if (rotationsTag.m_128441_(ModelPart.LEFT_LEG.getTagName())) {
            this.setModelLeftLegRotation(new CustomRotation(rotationsTag.m_128437_(ModelPart.LEFT_LEG.getTagName(), 5)));
        }
        if (rotationsTag.m_128441_(ModelPart.RIGHT_LEG.getTagName())) {
            this.setModelRightLegRotation(new CustomRotation(rotationsTag.m_128437_(ModelPart.RIGHT_LEG.getTagName(), 5)));
        }
        if (rotationsTag.m_128441_(ModelPart.ROOT.getTagName())) {
            this.setModelRootRotation(new CustomRotation(rotationsTag.m_128437_(ModelPart.ROOT.getTagName(), 5)));
        }
    }
}

