/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.gametest;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameTestHelpers {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");

    private GameTestHelpers() {
    }

    public static ServerPlayer mockServerPlayer(GameTestHelper helper, Vec3 position) {
        ServerPlayer serverPlayer = helper.m_287220_();
        GameTestHelpers.assertNotNull(helper, "ServerPlayer is null!", serverPlayer);
        serverPlayer.m_146884_(helper.m_177227_(position));
        helper.m_177374_(serverPlayer.m_6095_(), new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_));
        return serverPlayer;
    }

    public static EasyNPC<?> mockEasyNPC(GameTestHelper helper, EntityType<? extends PathfinderMob> entityType, Vec3 position) {
        EasyNPC<?> easyNPC = GameTestHelpers.spawnNPCEntityType(helper, entityType);
        GameTestHelpers.assertNotNull(helper, "EasyNPC is null!", easyNPC);
        easyNPC.getEntity().m_146884_(helper.m_177227_(position));
        helper.m_177374_(easyNPC.getEntity().m_6095_(), new BlockPos((int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_));
        return easyNPC;
    }

    public static EasyNPC<?> spawnNPCEntityType(GameTestHelper helper, EntityType<? extends PathfinderMob> entityType) {
        Object entity = GameTestHelpers.spawnEntityType(helper, entityType);
        if (entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            return easyNPC;
        }
        helper.m_177284_("Entity " + entityType + " is not an EasyNPC!");
        return null;
    }

    public static <T extends Entity> T spawnEntityType(GameTestHelper helper, EntityType<? extends PathfinderMob> entityType) {
        if (entityType == null) {
            helper.m_177284_("EntityType is null!");
            return null;
        }
        Player player = helper.m_177368_();
        Entity entity = entityType.m_20615_(player.m_9236_());
        if (entity == null) {
            helper.m_177284_("Entity for " + entityType + " is null!");
            return null;
        }
        if (player.m_9236_().m_7967_(entity)) {
            return (T)entity;
        }
        helper.m_177284_("Failed to spawn entity " + entityType + "!");
        return null;
    }

    public static void assertEquals(GameTestHelper helper, String message, Object expected, Object actual) {
        if (expected.equals(actual)) {
            helper.m_177412_();
        } else {
            helper.m_177284_(message);
        }
    }

    public static void assertTrue(GameTestHelper helper, String message, boolean condition) {
        if (condition) {
            helper.m_177412_();
        } else {
            helper.m_177284_(message);
        }
    }

    public static void assertNotNull(GameTestHelper helper, String message, Object object) {
        GameTestHelpers.assertTrue(helper, message, object != null);
    }
}

