/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft.common.tileentities;

import com.razz.decocraft.DecoException;
import com.razz.decocraft.common.JsonContainer;
import com.razz.decocraft.common.ModuleTileEntities;
import com.razz.decocraft.common.blocks.DecocraftBlock;
import com.razz.decocraft.models.bbmodel.BBModel;
import com.razz.decocraft.models.bbmodel.BBModelParts;
import com.razz.decocraft.network.DecocraftPacketHandler;
import com.razz.decocraft.network.server.SUpdateAnimation;
import com.razz.decocraft.utils.DecoMath;
import com.razz.decocraft.utils.nbt.NBTMeta;
import com.razz.decocraft.utils.nbt.NBTModel;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnimatedTileEntity
extends BlockEntity {
    private static final String NBT_ANIM_NAME = "animName";
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean isUnmodifiable = false;
    private JsonContainer.Entry meta;
    private BBModel model;
    private BBModelParts.Animation animation;
    private String animationName;
    private double timer = 0.0;
    private String sound = "";

    public AnimatedTileEntity(BlockPos pos, BlockState state) {
        super(ModuleTileEntities.ANIMATED_TE, pos, state);
    }

    public AnimatedTileEntity(BlockPos pos, BlockState state, @Nullable JsonContainer.Entry meta, @Nullable BBModel model) {
        this(pos, state);
        this.meta = meta;
        this.model = model;
        if (this.meta != null) {
            this.setAnimationName(meta.default_animation);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("meta")) {
            this.meta = NBTMeta.fromNBT(nbt.m_128469_("meta"));
        }
        if (nbt.m_128441_("model")) {
            this.model = NBTModel.fromNBT(nbt.m_128469_("model"));
        }
        if (nbt.m_128441_(NBT_ANIM_NAME)) {
            this.setAnimationName(nbt.m_128461_(NBT_ANIM_NAME));
        }
        if (nbt.m_128441_("isUnmodifiable")) {
            isUnmodifiable = nbt.m_128471_("isUnmodifiable");
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.saveNBTCustom(nbt);
        if (this.meta != null) {
            nbt.m_128365_("meta", (Tag)NBTMeta.toNBT(this.meta));
        }
        if (this.model != null) {
            nbt.m_128365_("model", (Tag)NBTModel.toNBT(this.model));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.saveNBTCustom(nbt);
        return nbt;
    }

    private void saveNBTCustom(CompoundTag nbt) {
        if (this.animationName != null) {
            nbt.m_128359_(NBT_ANIM_NAME, this.animationName);
        }
        nbt.m_128379_("isUnmodifiable", isUnmodifiable);
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getViewDistance() {
        return 64.0;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        AnimatedTileEntity be = (AnimatedTileEntity)blockEntity;
        if (!level.m_5776_()) {
            be.timer += 0.05;
            if (be.animation != null && be.timer >= (double)be.animation.length) {
                be.timer = 0.0;
                ((DecocraftBlock)state.m_60734_()).onAnimationEnd(state, level, be.f_58858_);
            }
        }
    }

    public String getAnimationName() {
        return this.animationName;
    }

    public void setAnimationName(String animName) {
        if (Objects.equals(animName, "any")) {
            animName = this.model.animationPerName.keySet().toArray(new String[0])[new Random().nextInt(this.model.animationPerName.size())];
        }
        if (Objects.equals(animName, "any_other")) {
            animName = this.animationName;
            while (Objects.equals(animName, this.animationName)) {
                animName = this.model.animationPerName.keySet().toArray(new String[0])[new Random().nextInt(this.model.animationPerName.size())];
            }
        }
        if (!Objects.equals(animName, this.animationName)) {
            this.timer = 0.0;
        }
        this.animationName = animName;
        this.m_6596_();
        this.animation = this.model.animationPerName.get(animName);
        if (this.animation == null) {
            throw new DecoException(String.format("Animation %s cannot be found in model %s", animName, this.model));
        }
        if (EffectiveSide.get().isServer()) {
            DecocraftPacketHandler.HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SUpdateAnimation(this.m_58899_(), animName));
        }
    }

    public double getTimer() {
        return this.timer;
    }

    public void addTimer(double timer) {
        this.timer += timer;
    }

    public Map<String, Map<BBModelParts.Channel, float[]>> getKeyframes() {
        HashMap<String, Map<BBModelParts.Channel, float[]>> results = new HashMap<String, Map<BBModelParts.Channel, float[]>>();
        if (this.animation == null || this.animation.length == 0.0f) {
            return results;
        }
        double timer = this.timer % (double)this.animation.length;
        for (Map.Entry<String, BBModelParts.Animator> animator : this.animation.animators.entrySet()) {
            String key = animator.getKey();
            List<BBModelParts.Keyframe> keyframes = animator.getValue().keyframes;
            results.put(key, new EnumMap(BBModelParts.Channel.class));
            for (BBModelParts.Channel channel : BBModelParts.Channel.values()) {
                BBModelParts.Keyframe lowKeyframe = keyframes.stream().filter(k -> k.channel == channel).filter(k -> (double)k.time < timer).max(Comparator.comparing(i -> Float.valueOf(i.time))).orElse(null);
                BBModelParts.Keyframe highKeyframe = keyframes.stream().filter(k -> k.channel == channel).filter(k -> (double)k.time >= timer).min(Comparator.comparing(i -> Float.valueOf(i.time))).orElse(null);
                if (lowKeyframe == null || highKeyframe == null) continue;
                BBModelParts.DataPoint low = lowKeyframe.data_points.get(0);
                BBModelParts.DataPoint high = highKeyframe.data_points.get(0);
                ((Map)results.get(key)).put(channel, new float[]{DecoMath.lerp(low.x, high.x, ((float)timer - lowKeyframe.time) / (highKeyframe.time - lowKeyframe.time)), DecoMath.lerp(low.y, high.y, ((float)timer - lowKeyframe.time) / (highKeyframe.time - lowKeyframe.time)), DecoMath.lerp(low.z, high.z, ((float)timer - lowKeyframe.time) / (highKeyframe.time - lowKeyframe.time))});
            }
        }
        return results;
    }
}

